/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.BaseEntity_;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowPostFunctionTrigger;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowStep_;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.model.workflow.entity.WorkflowVersion_;
import io.tesler.model.workflow.entity.WorkflowableTask;
import io.tesler.source.dto.WorkflowStepDto;
import io.tesler.source.dto.WorkflowStepDto_;
import io.tesler.source.services.data.WorkflowStepService;
import io.tesler.source.services.meta.WorkflowStepFieldMetaBuilder;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowStepServiceImpl
extends VersionAwareResponseService<WorkflowStepDto, WorkflowStep>
implements WorkflowStepService {
    @Autowired
    private WorkflowableTaskDao<?> workflowableTaskDao;

    public WorkflowStepServiceImpl() {
        super(WorkflowStepDto.class, WorkflowStep.class, WorkflowStep_.workflowVersion, WorkflowStepFieldMetaBuilder.class);
    }

    protected Specification<WorkflowStep> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfStepAutoClosed.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(BaseEntity_.id), (Object)bc.getParentIdAsLong()), (Expression)cb.equal((Expression)root.get(WorkflowStep_.linkedStatusCd), (Object)new LOV("AUTO_CLOSED")));
        }
        if (WorkflowServiceAssociation.wfTaskMigrationNewStep.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTemplateMigrationNewStep.isBc((BcIdentifier)bc)) {
            WorkflowableTask task = this.workflowableTaskDao.getTask(bc.getParentIdAsLong());
            return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow), (Object)task.getWorkflowTask().getWorkflowStep().getWorkflowVersion().getWorkflow()), cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.draft), (Object)Boolean.FALSE), cb.not((Expression)cb.equal((Expression)root.get(WorkflowStep_.workflowVersion), (Object)task.getWorkflowTask().getWorkflowStep().getWorkflowVersion()))});
        }
        return (Specification & Serializable)(root, cq, cb) -> {
            Long parentId = this.getWorkflowVersionId(bc);
            return parentId == null ? cb.and(new Predicate[0]) : cb.equal((Expression)root.get(WorkflowStep_.workflowVersion).get(BaseEntity_.id), (Object)parentId);
        };
    }

    protected Long getWorkflowVersionId(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfPostFuncTriggerWaitStep.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable(this.baseDAO.findById(WorkflowPostFunctionTrigger.class, bc.getParentIdAsLong())).map(WorkflowPostFunctionTrigger::getRequestPostFunction).map(WorkflowPostFunction::getConditionGroup).map(WorkflowTransitionConditionGroup::getTransition).map(WorkflowTransition::getSourceStep).map(WorkflowStep::getWorkflowVersion).map(BaseEntity::getId).orElse(null);
        }
        if (WorkflowServiceAssociation.wfTransitionDestStep.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable(this.baseDAO.findById(WorkflowTransition.class, bc.getParentIdAsLong())).map(WorkflowTransition::getSourceStep).map(WorkflowStep::getWorkflowVersion).map(BaseEntity::getId).orElse(null);
        }
        if (WorkflowServiceAssociation.wfTaskMigrationCurrentStep.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTemplateMigrationCurrentStep.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable(this.workflowableTaskDao.getTask(bc.getParentIdAsLong())).map(WorkflowableTask::getWorkflowTask).map(WorkflowTask::getWorkflowStep).map(WorkflowStep::getWorkflowVersion).map(BaseEntity::getId).orElse(null);
        }
        return bc.getParentIdAsLong();
    }

    protected ActionResultDTO<WorkflowStepDto> doUpdateEntity(WorkflowStep entity, WorkflowStepDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowStepDto_.name)) {
            entity.setName(dto.getName());
        }
        if (dto.isFieldChanged(WorkflowStepDto_.linkedStatusValue)) {
            entity.setLinkedStatusCd(dto.getLinkedStatusKey() == null ? null : new LOV(dto.getLinkedStatusKey()));
        }
        if (dto.isFieldChanged(WorkflowStepDto_.overdueTransitionId)) {
            entity.setOverdueTransition(dto.getOverdueTransitionId() == null ? null : (WorkflowTransition)this.baseDAO.findById(WorkflowTransition.class, dto.getOverdueTransitionId()));
        }
        if (dto.isFieldChanged(WorkflowStepDto_.linkedStatusValue)) {
            entity.setUuid(UUID.randomUUID().toString());
        }
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    public ActionResultDTO<WorkflowStepDto> deleteEntity(BusinessComponent bc) {
        this.baseDAO.delete(WorkflowStep.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected CreateResult<WorkflowStepDto> doCreateEntity(WorkflowStep entity, BusinessComponent bc) {
        entity.setUuid(UUID.randomUUID().toString());
        entity.setWorkflowVersion((WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getParentIdAsLong()));
        this.baseDAO.save((Object)entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    public Actions<WorkflowStepDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

