/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.api.data.ResultPage;
import io.tesler.core.controller.param.FilterParameter;
import io.tesler.core.controller.param.FilterParameters;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.controller.param.SearchOperation;
import io.tesler.core.crudma.bc.BcRegistry;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.core.crudma.bc.impl.InnerBcDescription;
import io.tesler.core.crudma.impl.AbstractResponseService;
import io.tesler.core.dto.data.AdminBcDto;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.ui.entity.View;
import io.tesler.model.ui.entity.ViewWidgets;
import io.tesler.model.ui.entity.ViewWidgets_;
import io.tesler.model.ui.entity.View_;
import io.tesler.model.ui.entity.Widget_;
import io.tesler.source.services.data.TaskChildBcService;
import io.tesler.source.services.data.WorkflowableTaskService;
import io.tesler.source.services.meta.TaskChildBcFieldMetaBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskChildBcServiceImpl
extends AbstractResponseService<AdminBcDto, BaseEntity>
implements TaskChildBcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskChildBcServiceImpl.class);
    @PersistenceContext(unitName="teslerEntityManagerFactory")
    private EntityManager entityManager;
    @Autowired
    private BcRegistry bcRegistry;

    public TaskChildBcServiceImpl() {
        super(AdminBcDto.class, BaseEntity.class, null, TaskChildBcFieldMetaBuilder.class);
    }

    public ResultPage<AdminBcDto> getList(BusinessComponent bc) {
        QueryParameters params = bc.getParameters();
        List<BcDescription> saValues = this.getAllBusCompBelowTask();
        Map<String, String> allViewsByBcNames = this.getAllViewsByBcNames(saValues.stream().map(BcDescription::getName).collect(Collectors.toList()));
        List resultList = saValues.stream().map(bcDescription -> {
            AdminBcDto adminBcDto = new AdminBcDto(bcDescription);
            adminBcDto.setAffectedWidgets((String)allViewsByBcNames.get(bcDescription.getName()));
            return adminBcDto;
        }).filter(dto -> this.filterByQueryParams((AdminBcDto)dto, params.getFilter())).collect(Collectors.toList());
        resultList = resultList.stream().skip(params.getPageNumber() * params.getPageSize()).limit(params.getPageSize() + 1).collect(Collectors.toList());
        return this.dtoListToResultPage(resultList, params.getPageSize());
    }

    private Map<String, String> getAllViewsByBcNames(List<String> bcNames) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createTupleQuery();
        Root viewWidgetsRoot = cq.from(ViewWidgets.class);
        Root viewRoot = cq.from(View.class);
        Join widgetJoin = viewWidgetsRoot.join(ViewWidgets_.widget);
        cq.multiselect(new Selection[]{widgetJoin.get(Widget_.bc), widgetJoin.get(Widget_.title), viewRoot.get(View_.title)});
        cq.where((Expression)cb.and((Expression)cb.or((Predicate[])bcNames.stream().map(bcName -> cb.equal((Expression)widgetJoin.get(Widget_.bc), bcName)).toArray(Predicate[]::new)), (Expression)cb.equal((Expression)viewWidgetsRoot.get(ViewWidgets_.viewName), (Expression)viewRoot.get(View_.name))));
        List resultList = this.entityManager.createQuery(cq).getResultList();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Tuple tuple : resultList) {
            LinkedList<Object> objects = new LinkedList<Object>(Arrays.asList(tuple.toArray()));
            String bc = (String)objects.get(0);
            String name = objects.get(1) + " -> " + objects.get(2);
            if (result.containsKey(bc)) {
                result.put(bc, (String)result.get(bc) + "\n" + name);
                continue;
            }
            result.put(bc, name);
        }
        return result;
    }

    private List<BcDescription> getAllBusCompBelowTask() {
        List<BcDescription> saValues = this.bcRegistry.select(bc -> bc.getParentName() != null).filter(bc -> this.isWorkflowBc(this.bcRegistry.getBcDescription(bc.getParentName()))).collect(Collectors.toList());
        List addonialSaValues = new ArrayList(saValues);
        do {
            ArrayList finalAddonialSaValues = addonialSaValues;
            addonialSaValues = this.bcRegistry.select(sa -> finalAddonialSaValues.contains(Optional.of(sa).map(BcDescription::getParentName).map(arg_0 -> ((BcRegistry)this.bcRegistry).getBcDescription(arg_0)).orElse(null))).collect(Collectors.toList());
            saValues.addAll(addonialSaValues);
        } while (!addonialSaValues.isEmpty());
        return saValues;
    }

    private boolean filterByQueryParams(AdminBcDto dto, FilterParameters searchParameters) {
        for (FilterParameter parameter : searchParameters) {
            if ("name".equals(parameter.getName())) {
                if (parameter.getOperation() == SearchOperation.EQUALS) {
                    return Objects.equals(parameter.getStringValue(), dto.getName());
                }
                if (parameter.getOperation() == SearchOperation.SPECIFIED) {
                    if (parameter.getBooleanValue().booleanValue()) {
                        return dto.getName() != null;
                    }
                    return dto.getName() == null;
                }
                if (parameter.getOperation() == SearchOperation.CONTAINS) {
                    if (parameter.getStringValue() == null) {
                        return true;
                    }
                    if (dto.getName() == null) {
                        return false;
                    }
                    return dto.getName().contains(parameter.getStringValue());
                }
                if (parameter.getOperation() == SearchOperation.CONTAINS_ONE_OF) {
                    return parameter.getStringValuesAsList().stream().anyMatch(param -> {
                        if (param == null) {
                            return true;
                        }
                        if (dto.getName() == null) {
                            return false;
                        }
                        return dto.getName().contains((CharSequence)param);
                    });
                }
                if (parameter.getOperation() == SearchOperation.EQUALS_ONE_OF) {
                    return parameter.getStringValuesAsList().stream().anyMatch(param -> Objects.equals(param, dto.getName()));
                }
            }
            if (!"affectedWidgets".equals(parameter.getName())) continue;
            if (parameter.getOperation() == SearchOperation.EQUALS) {
                return Objects.equals(parameter.getStringValue(), dto.getAffectedWidgets());
            }
            if (parameter.getOperation() == SearchOperation.SPECIFIED) {
                if (parameter.getBooleanValue().booleanValue()) {
                    return dto.getAffectedWidgets() != null;
                }
                return dto.getAffectedWidgets() == null;
            }
            if (parameter.getOperation() != SearchOperation.CONTAINS) continue;
            if (parameter.getStringValue() == null) {
                return true;
            }
            if (dto.getAffectedWidgets() == null) {
                return false;
            }
            return dto.getAffectedWidgets().contains(parameter.getStringValue());
        }
        return true;
    }

    public long count(BusinessComponent bc) {
        return this.bcRegistry.select(this::isWorkflowBc).count();
    }

    private boolean isWorkflowBc(BcDescription bcDescription) {
        return bcDescription instanceof InnerBcDescription && WorkflowableTaskService.class.isAssignableFrom(((InnerBcDescription)bcDescription).getServiceClass());
    }
}

