/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dict.WorkflowDictionaryType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.core.service.rowmeta.FieldMetaBuilder;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionValidation;
import io.tesler.model.workflow.entity.WorkflowTransitionValidation_;
import io.tesler.source.dto.WorkflowTransitionValidationDto;
import io.tesler.source.dto.WorkflowTransitionValidationDto_;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseWorkflowTransitionValidationServiceImpl<D extends WorkflowTransitionValidationDto, E extends WorkflowTransitionValidation>
extends VersionAwareResponseService<D, E> {
    public BaseWorkflowTransitionValidationServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected Specification<E> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionValidPreInvoke.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> {
                Long id = bc.getParentIdAsLong();
                if (Objects.nonNull(id)) {
                    return cb.equal((Expression)root.get(WorkflowTransitionValidation_.id), (Object)id);
                }
                return cb.and(new Predicate[0]);
            };
        }
        return super.getParentSpecification(bc);
    }

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D dto, BusinessComponent bc) {
        this.update(entity, dto, bc);
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected void update(E entity, D dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.seq)) {
            entity.setSeq(((WorkflowTransitionValidationDto)((Object)dto)).getSeq());
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.dmn)) {
            entity.setDmn(((WorkflowTransitionValidationDto)((Object)dto)).getDmn());
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.validCd)) {
            entity.setValidCd(WorkflowDictionaryType.WF_TRN_DATA_VAL.lookupName(((WorkflowTransitionValidationDto)((Object)dto)).getValidCd()));
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.errorMessage)) {
            entity.setErrorMessage(((WorkflowTransitionValidationDto)((Object)dto)).getErrorMessage());
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.preInvokeType)) {
            entity.setPreInvokeTypeCd(WorkflowDictionaryType.PRE_INVOKE_TYPE.lookupName(((WorkflowTransitionValidationDto)((Object)dto)).getPreInvokeType()));
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.preInvokeCond)) {
            entity.setPreInvokeCondCd(WorkflowDictionaryType.PRE_INVOKE_COND.lookupName(((WorkflowTransitionValidationDto)((Object)dto)).getPreInvokeCond()));
        }
        if (dto.isFieldChanged(WorkflowTransitionValidationDto_.preInvokeMessage)) {
            entity.setPreInvokeMessage(((WorkflowTransitionValidationDto)((Object)dto)).getPreInvokeMessage());
        }
    }

    public ActionResultDTO<D> deleteEntity(BusinessComponent bc) {
        this.baseDAO.delete(WorkflowTransitionValidation.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected final CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        entity.setConditionGroup((WorkflowTransitionConditionGroup)this.baseDAO.findById(WorkflowTransitionConditionGroup.class, bc.getParentIdAsLong()));
        this.baseDAO.save(entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected abstract E create(BusinessComponent var1);

    public Actions<D> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

