/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source;

import io.tesler.api.data.dto.rowmeta.ActionDTO;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionGroup;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;

public final class WorkflowActionUtils {
    private static final String WF_TRANSITION_ID = "wf_transition_id_";
    private static final ActionGroup WITHOUT_GROUP = new ActionGroup(null, null);

    public static String actionNameFromTransitionId(Long transitionId) {
        return WF_TRANSITION_ID + transitionId;
    }

    public static Long transitionIdFromActionName(String actionName) {
        return Long.valueOf(actionName.replace(WF_TRANSITION_ID, ""));
    }

    public static boolean isTransitionAction(String actionName) {
        return actionName.startsWith(WF_TRANSITION_ID);
    }

    public static List<ActionDTO> getActions(List<WorkflowTransition> transitions) {
        Map<ActionGroup, List<WorkflowTransition>> transitionGroup = transitions.stream().collect(Collectors.groupingBy(transition -> Optional.ofNullable(transition.getWorkflowTransitionGroup()).map(x$0 -> new ActionGroup((WorkflowTransitionGroup)x$0)).orElse(WITHOUT_GROUP), Collectors.mapping(Function.identity(), Collectors.toList())));
        List<ActionDTO> actionsWithoutGroup = WorkflowActionUtils.getActionsWithoutGroup(transitionGroup.remove(WITHOUT_GROUP));
        return ListUtils.union(WorkflowActionUtils.getActionWithGroup(transitionGroup), actionsWithoutGroup);
    }

    private static List<ActionDTO> getActionWithGroup(Map<ActionGroup, List<WorkflowTransition>> transitionGroup) {
        return transitionGroup.entrySet().stream().map(entry -> new ActionDTO(((ActionGroup)entry.getKey()).getText(), ((ActionGroup)entry.getKey()).getMaxGroupVisualButtonsCount().intValue(), WorkflowActionUtils.getActionsWithoutGroup((List)entry.getValue()))).collect(Collectors.toList());
    }

    private static List<ActionDTO> getActionsWithoutGroup(List<WorkflowTransition> transitions) {
        if (transitions != null) {
            return transitions.stream().map(transition -> new ActionDTO(WorkflowActionUtils.actionNameFromTransitionId(transition.getId()), transition.getName())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Generated
    private WorkflowActionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class ActionGroup {
        private final String text;
        private final Integer maxGroupVisualButtonsCount;

        private ActionGroup(WorkflowTransitionGroup transitionGroup) {
            this(transitionGroup.getNameButtonYet(), transitionGroup.getMaxShowButtonsInGroup());
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public Integer getMaxGroupVisualButtonsCount() {
            return this.maxGroupVisualButtonsCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionGroup)) {
                return false;
            }
            ActionGroup other = (ActionGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Integer this$maxGroupVisualButtonsCount = this.getMaxGroupVisualButtonsCount();
            Integer other$maxGroupVisualButtonsCount = other.getMaxGroupVisualButtonsCount();
            return !(this$maxGroupVisualButtonsCount == null ? other$maxGroupVisualButtonsCount != null : !((Object)this$maxGroupVisualButtonsCount).equals(other$maxGroupVisualButtonsCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ActionGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Integer $maxGroupVisualButtonsCount = this.getMaxGroupVisualButtonsCount();
            result = result * 59 + ($maxGroupVisualButtonsCount == null ? 43 : ((Object)$maxGroupVisualButtonsCount).hashCode());
            return result;
        }

        @Generated
        public ActionGroup(String text, Integer maxGroupVisualButtonsCount) {
            this.text = text;
            this.maxGroupVisualButtonsCount = maxGroupVisualButtonsCount;
        }
    }
}

