/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.service.PluginAware;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.DrillDownType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.ActionType;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.service.action.ActionAvailableChecker;
import io.tesler.core.service.action.Actions;
import io.tesler.core.service.action.ResponseServiceAction;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.engine.workflow.services.WorkflowSqlExporter;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.BaseEntity_;
import io.tesler.model.core.entity.FileEntity;
import io.tesler.model.workflow.entity.Workflow;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.model.workflow.entity.WorkflowVersion_;
import io.tesler.source.dto.WorkflowVersionDto;
import io.tesler.source.dto.WorkflowVersionDto_;
import io.tesler.source.services.action.WorkflowVersionMigrateTaskAction;
import io.tesler.source.services.data.WorkflowVersionService;
import io.tesler.source.services.meta.WorkflowVersionFieldMetaBuilder;
import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@PluginAware
public class WorkflowVersionServiceImpl
extends VersionAwareResponseService<WorkflowVersionDto, WorkflowVersion>
implements WorkflowVersionService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowVersionServiceImpl.class);
    @Autowired(required=false)
    private WorkflowSqlExporter workflowSqlExporter;
    @Autowired
    private WorkflowDao workflowDao;
    @Autowired
    private WorkflowVersionMigrateTaskAction workflowVersionMigrateTaskAction;

    public WorkflowVersionServiceImpl() {
        super(WorkflowVersionDto.class, WorkflowVersion.class, WorkflowVersion_.workflow, WorkflowVersionFieldMetaBuilder.class);
    }

    protected Specification<WorkflowVersion> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfActiveVersion.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowVersion_.workflow).get(BaseEntity_.id), (Object)bc.getParentIdAsLong()), (Expression)cb.equal((Expression)root.get(WorkflowVersion_.draft), (Object)Boolean.FALSE));
        }
        return super.getParentSpecification(bc);
    }

    protected ActionResultDTO<WorkflowVersionDto> doUpdateEntity(WorkflowVersion entity, WorkflowVersionDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowVersionDto_.description)) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.isFieldChanged(WorkflowVersionDto_.firstStepId)) {
            entity.setFirstStep(dto.getFirstStepId() == null ? null : (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getFirstStepId()));
        }
        if (dto.isFieldChanged(WorkflowVersionDto_.autoClosedStepId)) {
            entity.setAutoClosedStep(dto.getAutoClosedStepId() == null ? null : (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getAutoClosedStepId()));
        }
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected CreateResult<WorkflowVersionDto> doCreateEntity(WorkflowVersion entity, BusinessComponent bc) {
        Workflow workflow = (Workflow)this.baseDAO.findById(Workflow.class, bc.getParentIdAsLong());
        entity.setWorkflow(workflow);
        entity.setVersion(Double.valueOf(this.workflowDao.getNextVersion(workflow, false).doubleValue()));
        entity.setDraft(Boolean.TRUE.booleanValue());
        this.baseDAO.save((Object)entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    public Actions<WorkflowVersionDto> getActions() {
        return Actions.builder().create().available(this::isEditable).add().save().available(this::isEditable).add().action(ActionType.COPY).available(ActionAvailableChecker.and((ActionAvailableChecker[])new ActionAvailableChecker[]{bc -> this.workflowSqlExporter != null, this::versionIsNotDraft})).invoker(this::copyNewVersion).add().action("export-sql", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438").available(ActionAvailableChecker.and((ActionAvailableChecker[])new ActionAvailableChecker[]{bc -> this.workflowSqlExporter != null, this::versionIsNotDraft})).invoker(this::exportNewVersion).add().action("activate-version", "\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e").available(this::versionIsDraft).invoker(this::activateVersion).add().add("migrate-all-tasks", (ResponseServiceAction)this.workflowVersionMigrateTaskAction).build();
    }

    private ActionResultDTO<WorkflowVersionDto> exportNewVersion(BusinessComponent bc, WorkflowVersionDto data) {
        FileEntity fileEntity = this.workflowSqlExporter.exportNewVersion(bc, data);
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.downloadFile((String)String.valueOf(fileEntity.getId())));
    }

    private ActionResultDTO<WorkflowVersionDto> copyNewVersion(BusinessComponent bc, WorkflowVersionDto data) {
        WorkflowVersion newVersion = this.workflowSqlExporter.copyNewVersion(bc, data);
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.drillDown((DrillDownType)DrillDownType.INNER, (String)StringUtils.joinWith((String)"/", (Object[])new Object[]{"screen/admin/view/wftransitionfunc", WorkflowServiceAssociation.wfProject, newVersion.getWorkflow().getProject().getId(), WorkflowServiceAssociation.wf, newVersion.getWorkflow().getId(), WorkflowServiceAssociation.wfVersion, newVersion.getId()})));
    }

    private boolean isEditable(BusinessComponent bc) {
        return WorkflowServiceAssociation.migrationWfVersion.isNotBc((BcIdentifier)bc);
    }

    private boolean versionIsNotDraft(BusinessComponent bc) {
        return this.isEditable(bc) && bc.getId() != null && !((WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getIdAsLong())).isDraft();
    }

    private boolean versionIsDraft(BusinessComponent bc) {
        return this.isEditable(bc) && bc.getId() != null && ((WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getIdAsLong())).isDraft();
    }

    private ActionResultDTO<WorkflowVersionDto> activateVersion(BusinessComponent bc, WorkflowVersionDto data) {
        WorkflowVersion version = (WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getIdAsLong());
        version.setDraft(false);
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)version));
    }
}

