/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.service.PluginAware;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.BaseEntity_;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowPostFunctionTrigger;
import io.tesler.model.workflow.entity.WorkflowPostFunction_;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowStep_;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup_;
import io.tesler.model.workflow.entity.WorkflowTransitionGroup;
import io.tesler.model.workflow.entity.WorkflowTransition_;
import io.tesler.model.workflow.entity.WorkflowVersion_;
import io.tesler.model.workflow.entity.WorkflowableTask;
import io.tesler.source.dto.WorkflowTransitionDto;
import io.tesler.source.dto.WorkflowTransitionDto_;
import io.tesler.source.services.data.WorkflowTransitionService;
import io.tesler.source.services.meta.WorkflowTransitionFieldMetaBuilder;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@PluginAware
public class WorkflowTransitionServiceImpl
extends VersionAwareResponseService<WorkflowTransitionDto, WorkflowTransition>
implements WorkflowTransitionService {
    @Autowired
    private WorkflowableTaskDao<?> workflowableTaskDao;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowTransitionServiceImpl() {
        super(WorkflowTransitionDto.class, WorkflowTransition.class, WorkflowTransition_.sourceStep, WorkflowTransitionFieldMetaBuilder.class);
    }

    protected Specification<WorkflowTransition> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTemplateMigrationNewAutomaticTransition.isBc((BcIdentifier)bc)) {
            WorkflowableTask task = this.workflowableTaskDao.getTask(bc.getParentIdAsLong());
            return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow), (Object)task.getWorkflowTask().getWorkflowStep().getWorkflowVersion().getWorkflow()), cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.draft), (Object)Boolean.FALSE), cb.not((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion), (Object)task.getWorkflowTask().getWorkflowStep().getWorkflowVersion()))});
        }
        if (WorkflowServiceAssociation.wfTemplateMigrationCurrentAutomaticTransition.isBc((BcIdentifier)bc)) {
            WorkflowableTask task = this.workflowableTaskDao.getTask(bc.getParentIdAsLong());
            return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion), (Object)task.getWorkflowTask().getWorkflowStep().getWorkflowVersion());
        }
        return (Specification & Serializable)(root, cq, cb) -> {
            Long parentId = this.getSourceStepId(bc);
            return parentId == null ? cb.and(new Predicate[0]) : cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(BaseEntity_.id), (Object)parentId);
        };
    }

    private Long getSourceStepId(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfPostFuncTriggerTransition.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable(this.baseDAO.findById(WorkflowPostFunctionTrigger.class, bc.getParentIdAsLong())).map(WorkflowPostFunctionTrigger::getResponseWaitStep).map(BaseEntity::getId).orElse(null);
        }
        return bc.getParentIdAsLong();
    }

    protected ActionResultDTO<WorkflowTransitionDto> doUpdateEntity(WorkflowTransition entity, WorkflowTransitionDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionDto_.name)) {
            entity.setName(dto.getName());
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.workflowDestStepId)) {
            entity.setDestinationStep(dto.getWorkflowDestStepId() == null ? null : (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getWorkflowDestStepId()));
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.workflowTransitionGroupId)) {
            entity.setWorkflowTransitionGroup(dto.getWorkflowTransitionGroupId() == null ? null : (WorkflowTransitionGroup)this.baseDAO.findById(WorkflowTransitionGroup.class, dto.getWorkflowTransitionGroupId()));
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.workflowDestStepId)) {
            entity.setUuid(UUID.randomUUID().toString());
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.checkRequiredFields)) {
            entity.setCheckRequiredFields(dto.getCheckRequiredFields());
        }
        if (dto.isFieldChanged(WorkflowTransitionDto_.backgroundExecution)) {
            entity.setBackgroundExecution(dto.getBackgroundExecution());
        }
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    public ActionResultDTO<WorkflowTransitionDto> deleteEntity(BusinessComponent bc) {
        WorkflowTransitionConditionGroup workflowGroup = (WorkflowTransitionConditionGroup)this.baseDAO.getSingleResultOrNull(WorkflowTransitionConditionGroup.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowTransitionConditionGroup_.transition).get(WorkflowTransition_.id), (Object)bc.getIdAsLong()));
        if (workflowGroup != null) {
            WorkflowPostFunction workflowPostFunction = (WorkflowPostFunction)this.baseDAO.getSingleResultOrNull(WorkflowPostFunction.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowPostFunction_.conditionGroup), (Object)workflowGroup));
            if (workflowPostFunction != null) {
                this.baseDAO.delete(WorkflowPostFunction.class, workflowPostFunction.getId());
            }
            this.baseDAO.delete(WorkflowTransitionConditionGroup.class, workflowGroup.getId());
        }
        this.baseDAO.delete(WorkflowTransition.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected CreateResult<WorkflowTransitionDto> doCreateEntity(WorkflowTransition entity, BusinessComponent bc) {
        entity.setUuid(UUID.randomUUID().toString());
        entity.setSourceStep((WorkflowStep)this.baseDAO.findById(WorkflowStep.class, bc.getParentIdAsLong()));
        entity.setDestinationStep((WorkflowStep)this.baseDAO.findById(WorkflowStep.class, bc.getParentIdAsLong()));
        entity.setCheckRequiredFields(Boolean.TRUE);
        this.baseDAO.save((Object)entity);
        WorkflowTransitionConditionGroup defaultPostFunctionGroup = this.createDefaultConditionGroup(entity);
        this.workflowDao.createDefaultPostFunctions(defaultPostFunctionGroup);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    private WorkflowTransitionConditionGroup createDefaultConditionGroup(WorkflowTransition transition) {
        WorkflowTransitionConditionGroup postFunctionGroup = new WorkflowTransitionConditionGroup();
        postFunctionGroup.setTransition(transition);
        postFunctionGroup.setSeq(Long.valueOf(1L));
        postFunctionGroup.setName("\u0413\u0440\u0443\u043f\u043f\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        postFunctionGroup.setCondGroupCd(WorkflowDictionaries.ConditionGroupType.POST_FUNCTION);
        this.baseDAO.save((Object)postFunctionGroup);
        return postFunctionGroup;
    }

    public Actions<WorkflowTransitionDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

