/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.service.action.Actions;
import io.tesler.core.util.session.SessionService;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.Department;
import io.tesler.model.workflow.entity.Workflow;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.source.dto.WorkflowDto;
import io.tesler.source.dto.WorkflowDto_;
import io.tesler.source.services.data.WorkflowService;
import io.tesler.source.services.meta.WorkflowFieldMetaBuilder;
import java.io.Serializable;
import java.util.List;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowServiceImpl
extends VersionAwareResponseService<WorkflowDto, Workflow>
implements WorkflowService {
    @Autowired
    private SessionService sessionService;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowServiceImpl() {
        super(WorkflowDto.class, Workflow.class, null, WorkflowFieldMetaBuilder.class);
    }

    protected Specification<Workflow> getParentSpecification(BusinessComponent bc) {
        if (WorkflowServiceAssociation.pfChildWorkflow.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]);
        }
        return super.getParentSpecification(bc);
    }

    protected ActionResultDTO<WorkflowDto> doUpdateEntity(Workflow entity, WorkflowDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowDto_.deptId)) {
            entity.setDepartment((Department)this.baseDAO.findById(Department.class, dto.getDeptId()));
        }
        if (dto.isFieldChanged(WorkflowDto_.name)) {
            entity.setName(dto.getName());
        }
        if (dto.isFieldChanged(WorkflowDto_.description)) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.isFieldChanged(WorkflowDto_.taskTypeCd)) {
            entity.setTaskTypeCd(DictionaryType.TASK_TYPE.lookupName(dto.getTaskTypeCd()));
        }
        if (dto.isFieldChanged(WorkflowDto_.activeVersion)) {
            entity.setActiveVersion(dto.getActiveVersionId() == null ? null : (WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, dto.getActiveVersionId()));
        }
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    public ActionResultDTO<WorkflowDto> deleteEntity(BusinessComponent bc) {
        this.baseDAO.delete(Workflow.class, bc.getIdAsLong());
        return new ActionResultDTO();
    }

    protected CreateResult<WorkflowDto> doCreateEntity(Workflow entity, BusinessComponent bc) {
        List<LOV> taskTypes = this.workflowDao.getTaskTypesNotInWf();
        if (taskTypes.isEmpty()) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.no_task_type_available"));
        }
        entity.setTaskTypeCd(taskTypes.get(0));
        entity.setDepartment(this.sessionService.getSessionUserDepartment());
        this.baseDAO.save((Object)entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    public Actions<WorkflowDto> getActions() {
        return Actions.builder().create().available(this::hasTaskTypesNotInWf).add().save().available(this::isEditable).add().delete().available(this::isEditable).add().build();
    }

    private boolean hasTaskTypesNotInWf(BusinessComponent bc) {
        return this.isEditable(bc) && !this.workflowDao.getTaskTypesNotInWf().isEmpty();
    }

    private boolean isEditable(BusinessComponent bc) {
        return WorkflowServiceAssociation.migrationWf.isNotBc((BcIdentifier)bc);
    }
}

