/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.crudma;

import com.google.common.collect.ImmutableList;
import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.ResultPage;
import io.tesler.api.data.dictionary.DictionaryCache;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dictionary.IDictionaryType;
import io.tesler.api.data.dictionary.SimpleDictionary;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.data.dto.rowmeta.FieldDTO;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.AbstractCrudmaService;
import io.tesler.core.dto.rowmeta.MetaDTO;
import io.tesler.core.util.ListPaging;
import io.tesler.source.services.crudma.DictionaryDto_;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class WorkflowDictionaryCrudmaService
extends AbstractCrudmaService {
    private final List<FieldDTO> FIELD_DTO_LIST = ImmutableList.builder().add((Object)FieldDTO.disabledFilterableField(DictionaryDto_.key)).add((Object)FieldDTO.disabledFilterableField(DictionaryDto_.value)).add((Object)FieldDTO.disabledFilterableField(DictionaryDto_.description)).build();
    private final DictionaryCache dictionaryCache;

    private Collection<SimpleDictionary> getDictionaries(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfStepType.isBc((BcIdentifier)bc)) {
            return this.dictionaryCache.getAll((IDictionaryType)DictionaryType.TASK_STATUS);
        }
        return Collections.emptyList();
    }

    public ResultPage<? extends DataResponseDTO> getAll(BusinessComponent bc) {
        List dictionaries = this.getDictionaries(bc).stream().map(x$0 -> new DictionaryDto((SimpleDictionary)x$0)).collect(Collectors.toList());
        return ListPaging.getResultPage(dictionaries, (QueryParameters)bc.getParameters());
    }

    public long count(BusinessComponent bc) {
        return this.getDictionaries(bc).size();
    }

    public MetaDTO getMeta(BusinessComponent bc) {
        return this.buildMeta(this.FIELD_DTO_LIST);
    }

    public MetaDTO getMetaEmpty(BusinessComponent bc) {
        return this.buildMeta(Collections.emptyList());
    }

    @ConstructorProperties(value={"dictionaryCache"})
    @Generated
    public WorkflowDictionaryCrudmaService(DictionaryCache dictionaryCache) {
        this.dictionaryCache = dictionaryCache;
    }

    final class DictionaryDto
    extends DataResponseDTO {
        private String key;
        private String value;
        private String description;

        DictionaryDto(SimpleDictionary dict) {
            this.id = dict.getKey();
            this.key = dict.getKey();
            this.value = dict.getValue();
            this.description = dict.getDescription();
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public DictionaryDto() {
        }
    }
}

