/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services;

import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.exception.BusinessException;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTask_;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.model.workflow.entity.WorkflowableTask;
import io.tesler.model.workflow.entity.WorkflowableTask_;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.jpa.domain.Specification;

public abstract class AbstractWorkflowableTaskDao<E extends WorkflowableTask>
implements WorkflowableTaskDao<E> {
    protected final WorkflowSettings<E> workflowSettings;
    protected final JpaDao jpaDao;

    public E getTask(Long id) {
        WorkflowableTask task = (WorkflowableTask)this.jpaDao.findById(this.workflowSettings.getEntityClass(), id);
        if (task == null) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.task_not_found", (Object[])new Object[]{id}));
        }
        return (E)task;
    }

    @Override
    public E getTask(WorkflowTask workflowTask) {
        return (E)((WorkflowableTask)this.jpaDao.getSingleResultOrNull(this.workflowSettings.getEntityClass(), (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowableTask_.workflowTask), (Object)workflowTask)));
    }

    @Override
    public List<WorkflowTask> getPendingTransitionWorkflowTasks() {
        return this.jpaDao.getList(this.workflowSettings.getEntityClass(), WorkflowTask.class, (root, cb) -> root.get(WorkflowableTask_.workflowTask), (Specification & Serializable)(root, query, cb) -> root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.pendingTransition).isNotNull());
    }

    @Override
    public List<E> getOtherVersionTasks(WorkflowVersion version) {
        return this.jpaDao.getList(this.workflowSettings.getEntityClass(), (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.workflowName), (Object)version.getWorkflow().getName()), (Expression)cb.not((Expression)cb.equal((Expression)root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.version), (Object)version.getVersion()))));
    }

    @ConstructorProperties(value={"workflowSettings", "jpaDao"})
    @Generated
    public AbstractWorkflowableTaskDao(WorkflowSettings<E> workflowSettings, JpaDao jpaDao) {
        this.workflowSettings = workflowSettings;
        this.jpaDao = jpaDao;
    }
}

