/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dict.WorkflowDictionaryType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.core.service.rowmeta.FieldMetaBuilder;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowPostFunction_;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup_;
import io.tesler.source.dto.WorkflowPostFunctionDto;
import io.tesler.source.dto.WorkflowPostFunctionDto_;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseWorkflowPostFunctionServiceImpl<D extends WorkflowPostFunctionDto, E extends WorkflowPostFunction>
extends VersionAwareResponseService<D, E> {
    @Autowired
    private WorkflowDao workflowDao;

    public BaseWorkflowPostFunctionServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D dto, BusinessComponent bc) {
        this.update(entity, dto, bc);
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected void update(E entity, D dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowPostFunctionDto_.seq)) {
            entity.setSeq(((WorkflowPostFunctionDto)((Object)dto)).getSeq());
        }
        if (dto.isFieldChanged(WorkflowPostFunctionDto_.actionCd)) {
            entity.setActionCd(WorkflowDictionaryType.WF_TRN_ACT.lookupName(((WorkflowPostFunctionDto)((Object)dto)).getActionCd()));
        }
        if (dto.isFieldChanged(WorkflowPostFunctionDto_.stepTerm)) {
            entity.setStepTerm(((WorkflowPostFunctionDto)((Object)dto)).getStepTerm());
        }
    }

    protected final CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        entity.setConditionGroup((WorkflowTransitionConditionGroup)this.baseDAO.findById(WorkflowTransitionConditionGroup.class, bc.getParentIdAsLong()));
        Optional<WorkflowPostFunction> workflowPostFunction = this.baseDAO.getList(WorkflowPostFunction.class, Specification.where((Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowPostFunction_.conditionGroup).get(WorkflowTransitionConditionGroup_.id), (Object)bc.getParentIdAsLong()))).stream().filter(o -> !Objects.isNull(o.getSeq())).max(Comparator.comparing(WorkflowPostFunction::getSeq));
        entity.setSeq(workflowPostFunction.map(workflowPostFunction1 -> workflowPostFunction1.getSeq() + 1L).orElse(1L));
        entity.setActionCd(WorkflowDictionaryType.WF_TRN_ACT.lookupName("SetStepTerm"));
        this.baseDAO.save(entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected abstract E create(BusinessComponent var1);

    public ActionResultDTO<D> deleteEntity(BusinessComponent bc) {
        this.workflowDao.deletePostFunction((WorkflowPostFunction)this.isExist(bc.getIdAsLong()));
        return new ActionResultDTO();
    }

    public Actions<D> getActions() {
        return Actions.builder().create().available(this::isCreateAvailable).add().save().add().delete().add().build();
    }

    protected boolean isCreateAvailable(BusinessComponent bc) {
        return true;
    }
}

