/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.action;

import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.service.tx.TransactionService;
import io.tesler.api.util.Invoker;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.dto.MessageType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.service.action.ResponseServiceAction;
import io.tesler.core.util.session.SessionService;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.model.workflow.entity.WorkflowableTask;
import io.tesler.source.dto.WorkflowVersionDto;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WorkflowVersionMigrateTaskAction
extends ResponseServiceAction<WorkflowVersionDto> {
    private final JpaDao jpaDao;
    private final AsyncTaskMigration asyncTaskMigration;

    public String getButtonName() {
        return "\u041c\u0438\u0433\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0437\u0430\u0434\u0430\u0447\u0438 \u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u044b \u043d\u0430 \u044d\u0442\u0443 \u0432\u0435\u0440\u0441\u0438\u044e";
    }

    public boolean isAvailable(BusinessComponent bc) {
        return bc.getId() != null && !((WorkflowVersion)this.jpaDao.findById(WorkflowVersion.class, bc.getIdAsLong())).isDraft();
    }

    public ActionResultDTO<WorkflowVersionDto> invoke(BusinessComponent bc, WorkflowVersionDto data) {
        this.asyncTaskMigration.invokeAsync(bc.getIdAsLong());
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.showMessage((MessageType)MessageType.INFO, (String)ErrorMessageSource.errorMessage((String)"info.workflow_migration_has_been_started")));
    }

    @ConstructorProperties(value={"jpaDao", "asyncTaskMigration"})
    @Generated
    public WorkflowVersionMigrateTaskAction(JpaDao jpaDao, AsyncTaskMigration asyncTaskMigration) {
        this.jpaDao = jpaDao;
        this.asyncTaskMigration = asyncTaskMigration;
    }

    @Service
    public static class AsyncTaskMigration {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(AsyncTaskMigration.class);
        private final JpaDao jpaDao;
        private final SessionService sessionService;
        private final WorkflowableTaskDao<?> workflowableTaskDao;
        private final WorkflowDao workflowDao;
        private final TransactionService txService;

        @Async
        void invokeAsync(Long versionId) {
            try {
                this.txService.invokeInTx(Invoker.of(() -> this.doInvoke(versionId)));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        private void doInvoke(Long versionId) {
            WorkflowVersion version = (WorkflowVersion)this.jpaDao.findById(WorkflowVersion.class, versionId);
            List<?> tasks = this.workflowableTaskDao.getOtherVersionTasks(version);
            int migrated = 0;
            int skipped = 0;
            for (WorkflowableTask task : tasks) {
                boolean shouldSkip;
                WorkflowTransition newAutomaticTransition = this.getNewAutomaticTransition(version, task);
                WorkflowStep newStep = this.getNewStep(version, task, newAutomaticTransition);
                boolean bl = shouldSkip = task.getWorkflowTask() != null && newStep == null || task.getAutomaticTransitionName() != null && newAutomaticTransition == null;
                if (shouldSkip) {
                    ++skipped;
                    continue;
                }
                this.workflowDao.setWorkflowStep(task.getWorkflowTask(), newStep);
                task.setAutomaticTransitionName((String)Optional.ofNullable(newAutomaticTransition).map(WorkflowTransition::getName).orElse(null));
                ++migrated;
            }
        }

        private WorkflowTransition getNewAutomaticTransition(WorkflowVersion version, WorkflowableTask task) {
            if (task.getAutomaticTransitionName() == null) {
                return null;
            }
            return this.workflowDao.getTransitionByName(version, task.getAutomaticTransitionName());
        }

        private WorkflowStep getNewStep(WorkflowVersion version, WorkflowableTask task, WorkflowTransition newAutomaticTransition) {
            if (newAutomaticTransition != null) {
                return newAutomaticTransition.getSourceStep();
            }
            if (task.getWorkflowTask() != null) {
                return this.workflowDao.getStepByName(version, task.getWorkflowTask().getStepName());
            }
            return null;
        }

        @ConstructorProperties(value={"jpaDao", "sessionService", "workflowableTaskDao", "workflowDao", "txService"})
        @Generated
        public AsyncTaskMigration(JpaDao jpaDao, SessionService sessionService, WorkflowableTaskDao<?> workflowableTaskDao, WorkflowDao workflowDao, TransactionService txService) {
            this.jpaDao = jpaDao;
            this.sessionService = sessionService;
            this.workflowableTaskDao = workflowableTaskDao;
            this.workflowDao = workflowDao;
            this.txService = txService;
        }
    }
}

