/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.export.sql.db;

import com.google.common.base.Splitter;
import com.google.common.collect.Streams;
import io.tesler.sqlbc.dao.SqlFieldType;
import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class ColumnValue {
    private final SqlFieldType type;
    private final Object objectValue;

    public String getValueForInsert() {
        switch (this.type) {
            case STRING: {
                return "'" + this.escapeString(this.objectValue) + "'";
            }
            case CLOB: {
                return Streams.stream((Iterable)Splitter.fixedLength((int)2000).split((CharSequence)String.valueOf(this.objectValue))).map(this::escapeString).map(string -> "TO_CLOB('" + string + "')").collect(Collectors.joining(" || "));
            }
            case BOOLEAN: {
                return BooleanUtils.isTrue((Boolean)((Boolean)this.objectValue)) ? "1" : "0";
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return this.timestamp(this.objectValue);
            }
        }
        return String.valueOf(this.objectValue);
    }

    private String escapeString(Object src) {
        return String.valueOf(src).replace("'", "''");
    }

    private String timestamp(Object src) {
        return "TO_TIMESTAMP('" + String.valueOf(src) + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    @Generated
    public SqlFieldType getType() {
        return this.type;
    }

    @Generated
    public Object getObjectValue() {
        return this.objectValue;
    }

    @Generated
    public String toString() {
        return "ColumnValue(type=" + (Object)((Object)this.getType()) + ", objectValue=" + this.getObjectValue() + ")";
    }

    @ConstructorProperties(value={"type", "objectValue"})
    @Generated
    public ColumnValue(SqlFieldType type, Object objectValue) {
        this.type = type;
        this.objectValue = objectValue;
    }
}

