/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.dao;

import io.tesler.api.config.TeslerBeanProperties;
import io.tesler.api.data.ResultPage;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.util.session.SessionService;
import io.tesler.sqlbc.crudma.SqlBcDescription;
import io.tesler.sqlbc.crudma.SqlComponentObject;
import io.tesler.sqlbc.dao.SqlBcJdbcTemplate;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.stereotype.Service;

@Service
public class SqlComponentDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlComponentDao.class);
    private final SqlBcJdbcTemplate jdbcTemplate;

    @Autowired
    public SqlComponentDao(ApplicationContext applicationContext, TeslerBeanProperties teslerBeanProperties, SessionService sessionService, @Qualifier(value="primaryDatabase") Database primaryDatabase) {
        this.jdbcTemplate = new SqlBcJdbcTemplate(sessionService, (DataSource)applicationContext.getBean(teslerBeanProperties.getDataSource(), DataSource.class), primaryDatabase);
    }

    public ResultPage<SqlComponentObject> getPage(BusinessComponent bc, QueryParameters queryParameters) {
        SqlBcDescription bcDescription = (SqlBcDescription)bc.getDescription();
        return this.jdbcTemplate.page(bcDescription, bc.getParentId(), queryParameters, new SqlComponentRowMapper(bcDescription));
    }

    public SqlComponentObject getOne(BusinessComponent bc, QueryParameters queryParameters) {
        SqlBcDescription bcDescription = (SqlBcDescription)bc.getDescription();
        return (SqlComponentObject)((Object)this.jdbcTemplate.one(bcDescription, bc.getId(), bc.getParentId(), queryParameters, new SqlComponentRowMapper(bcDescription)));
    }

    public long count(BusinessComponent bc, QueryParameters queryParameters) {
        SqlBcDescription bcDescription = (SqlBcDescription)bc.getDescription();
        return this.jdbcTemplate.count(bcDescription, bc.getParentId(), queryParameters);
    }

    private static class SqlComponentRowMapper<T extends SqlComponentObject>
    implements RowMapper<T> {
        private final SqlBcDescription bcDescription;
        private final Class<T> cls;

        private SqlComponentRowMapper(SqlBcDescription bcDescription) {
            this.bcDescription = bcDescription;
            BeanGenerator generator = new BeanGenerator();
            generator.setSuperclass(SqlComponentObject.class);
            for (SqlBcDescription.Field field : this.bcDescription.getFields()) {
                String fieldName = field.getFieldName();
                if (SqlComponentObject.isIdField(fieldName)) continue;
                generator.addProperty(fieldName, field.getType().getJavaClass());
            }
            this.cls = (Class)generator.createClass();
        }

        public T mapRow(ResultSet rs, int rowNum) throws SQLException {
            try {
                SqlComponentObject result = (SqlComponentObject)((Object)this.cls.newInstance());
                for (SqlBcDescription.Field field : this.bcDescription.getFields()) {
                    Object value = rs.getObject(field.getColumnName(), field.getType().getJavaClass());
                    result.set(field.getFieldName(), value);
                }
                return (T)((Object)result);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new SQLException(ex);
            }
        }
    }
}

