/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.controller;

import io.tesler.api.config.TeslerBeanProperties;
import io.tesler.api.data.PageSpecification;
import io.tesler.api.data.ResultPage;
import io.tesler.api.service.tx.TransactionService;
import io.tesler.api.util.Invoker;
import io.tesler.core.dto.ResponseDTO;
import io.tesler.core.util.ResponseBuilder;
import io.tesler.sqlbc.dao.SqlFieldType;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{ (${tesler.api.use-servlet-context-path} == true) ? '':  '${tesler.api.path}'}/sql"})
public class SQLController {
    private static final int DEFAULT_PAGE_NUMBER = 1;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final int MAX_PAGE_SIZE = 1000;
    private final JdbcTemplate jdbcTemplate;
    @Autowired
    private TransactionService txService;

    @Autowired
    public SQLController(ApplicationContext applicationContext, TeslerBeanProperties teslerBeanProperties) {
        this.jdbcTemplate = new JdbcTemplate((DataSource)applicationContext.getBean(teslerBeanProperties.getDataSource(), DataSource.class));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"execute"})
    public ResponseDTO execute(@RequestBody Map<String, Object> requestBody, PageSpecification page) {
        boolean readOnly = true;
        String query = this.getQuery(requestBody, page, readOnly);
        Invoker callable = () -> this.executeQuery(query, Math.min(page.getPageSize(), 1000));
        return (ResponseDTO)this.txService.invokeInNewROTx(callable);
    }

    private String getQuery(Map<String, Object> requestBody, PageSpecification page, boolean readOnly) {
        String query = (String)requestBody.get("query");
        if (readOnly) {
            query = String.format("select * from (select row_.*, rownum rownum_ from (%s) row_ where rownum <= %d) where rownum_ > %d", query, page.getTo(), page.getTo());
        }
        return query;
    }

    private ResponseDTO executeQuery(String query, int pageSize) {
        return (ResponseDTO)this.jdbcTemplate.execute(query, cs -> {
            boolean result = cs.execute();
            if (result) {
                return new ResponseDTO(this.extractRows(cs, pageSize));
            }
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("affected_rows", cs.getUpdateCount());
            return ResponseBuilder.build(Collections.singletonList(data));
        });
    }

    private Map<String, ?> extractRow(ResultSet rs, Map<String, SqlFieldType> meta) throws SQLException {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, SqlFieldType> entry : meta.entrySet()) {
            String key = entry.getKey();
            SqlFieldType value = entry.getValue();
            result.put(key, rs.getObject(key, value.getJavaClass()));
        }
        return result;
    }

    private Map<String, SqlFieldType> extractMeta(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        LinkedHashMap<String, SqlFieldType> result = new LinkedHashMap<String, SqlFieldType>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String columnName = metaData.getColumnName(i);
            SqlFieldType columnType = SqlFieldType.Holder.getFromSqlType(metaData.getColumnType(i));
            result.put(columnName, columnType);
        }
        return result;
    }

    private ResultPage<?> extractRows(CallableStatement cs, int pageSize) throws SQLException {
        try (ResultSet rs = cs.getResultSet();){
            Map<String, SqlFieldType> meta = this.extractMeta(rs);
            ArrayList result = new ArrayList(pageSize);
            for (int rows = 0; rows < pageSize && rs.next(); ++rows) {
                result.add(this.extractRow(rs, meta));
            }
            ResultPage resultPage = ResultPage.of(result, (boolean)rs.next());
            return resultPage;
        }
    }
}

