/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.dao;

import io.tesler.api.data.ResultPage;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.util.session.SessionService;
import io.tesler.sqlbc.crudma.SqlBcDescription;
import io.tesler.sqlbc.dao.SqlBcQuery;
import io.tesler.sqlbc.exception.BadSqlComponentException;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.persistence.NoResultException;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.orm.jpa.vendor.Database;

public final class SqlBcJdbcTemplate {
    private final SessionService sessionService;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final Database database;

    public SqlBcJdbcTemplate(SessionService sessionService, @Qualifier(value="primaryDS") DataSource dataSource, @Qualifier(value="primaryDatabase") Database primaryDatabase) {
        this.sessionService = sessionService;
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        this.database = primaryDatabase;
    }

    public <T> ResultPage<T> page(SqlBcDescription bcDescription, String parentId, QueryParameters queryParameters, RowMapper<T> rowMapper) {
        SqlBcQuery query = SqlBcQuery.build(this.sessionService, bcDescription, null, parentId, queryParameters, this.database);
        try {
            return (ResultPage)this.jdbcTemplate.query(query.pageQuery(), query.parameterSource(), new PageableResultSetExtractor<T>(queryParameters.getPageSize(), rowMapper));
        }
        catch (BadSqlGrammarException e) {
            throw new BadSqlComponentException(bcDescription.getName(), e);
        }
    }

    public long count(SqlBcDescription bcDescription, String parentId, QueryParameters queryParameters) {
        SqlBcQuery query = SqlBcQuery.build(this.sessionService, bcDescription, null, parentId, queryParameters, this.database);
        try {
            return (Long)this.jdbcTemplate.queryForObject(query.countQuery(), query.parameterSource(), Long.class);
        }
        catch (BadSqlGrammarException e) {
            throw new BadSqlComponentException(bcDescription.getName(), e);
        }
    }

    public <T> T one(SqlBcDescription bcDescription, String id, String parentId, QueryParameters queryParameters, RowMapper<T> rowMapper) {
        SqlBcQuery query = SqlBcQuery.build(this.sessionService, bcDescription, id, parentId, queryParameters, this.database);
        try {
            return (T)this.jdbcTemplate.queryForObject(query.idQuery(), query.parameterSource(), rowMapper);
        }
        catch (BadSqlGrammarException e) {
            throw new BadSqlComponentException(bcDescription.getName(), e);
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoResultException("\u041f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b " + bcDescription.getName() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0438 \u0441 id=" + id);
        }
    }

    private static final class PageableResultSetExtractor<T>
    implements ResultSetExtractor<ResultPage<T>> {
        private final long pageSize;
        private final RowMapper<T> rowMapper;

        public ResultPage<T> extractData(ResultSet rs) throws SQLException {
            ArrayList<Object> results = new ArrayList<Object>();
            int rowNum = 0;
            while ((long)rowNum < this.pageSize && rs.next()) {
                results.add(this.rowMapper.mapRow(rs, rowNum++));
            }
            return new ResultPage(results, rs.next());
        }

        @ConstructorProperties(value={"pageSize", "rowMapper"})
        @Generated
        public PageableResultSetExtractor(long pageSize, RowMapper<T> rowMapper) {
            this.pageSize = pageSize;
            this.rowMapper = rowMapper;
        }
    }
}

