/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.export.base;

import io.tesler.sqlbc.export.base.model.ColumnMeta;
import io.tesler.sqlbc.export.base.model.ExportedRecord;
import io.tesler.sqlbc.export.base.model.TableMeta;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;

public class ExportedRecordRowMapper
implements RowMapper<ExportedRecord> {
    private final TableMeta tableMeta;

    public ExportedRecordRowMapper(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public ExportedRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
        ExportedRecord exportedRecord = new ExportedRecord(this.tableMeta.getTableName());
        for (ColumnMeta columnMeta : this.tableMeta.getColumns()) {
            if (columnMeta.getName().equals("ID")) {
                exportedRecord.setId(rs.getBigDecimal(columnMeta.getName()));
            }
            exportedRecord.addColumn(columnMeta, rs.getObject(columnMeta.getName(), columnMeta.getType().getJavaClass()));
        }
        return exportedRecord;
    }
}

