/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.dao;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.util.tz.TimeZoneUtil;
import io.tesler.core.controller.param.BindParameter;
import io.tesler.core.controller.param.BindsParameters;
import io.tesler.core.controller.param.FilterParameter;
import io.tesler.core.controller.param.FilterParameters;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.controller.param.SearchOperation;
import io.tesler.core.controller.param.SortParameter;
import io.tesler.core.controller.param.SortParameters;
import io.tesler.core.dto.data.SqlBcEditFieldDTO_;
import io.tesler.core.exception.ClientException;
import io.tesler.core.util.DateTimeUtil;
import io.tesler.core.util.TypeConverter;
import io.tesler.core.util.session.SessionService;
import io.tesler.sqlbc.crudma.SqlBcDescription;
import io.tesler.sqlbc.dao.SqlFieldType;
import java.beans.ConstructorProperties;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.orm.jpa.vendor.Database;

public final class SqlBcQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlBcQuery.class);
    public static final String FIELD_ID = "id";
    public static final Map<String, SqlFieldType> EXTRA_FIELDS = new ImmutableMap.Builder().put((Object)SqlBcEditFieldDTO_.edit_string1.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string2.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string3.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string4.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string5.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string6.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string7.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string8.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string9.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_string10.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_lov1.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_lov2.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_lov3.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_lov4.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_lov5.getName(), (Object)SqlFieldType.STRING).put((Object)SqlBcEditFieldDTO_.edit_number1.getName(), (Object)SqlFieldType.BIG_DECIMAL).put((Object)SqlBcEditFieldDTO_.edit_number2.getName(), (Object)SqlFieldType.BIG_DECIMAL).put((Object)SqlBcEditFieldDTO_.edit_number3.getName(), (Object)SqlFieldType.BIG_DECIMAL).put((Object)SqlBcEditFieldDTO_.edit_number4.getName(), (Object)SqlFieldType.BIG_DECIMAL).put((Object)SqlBcEditFieldDTO_.edit_number5.getName(), (Object)SqlFieldType.BIG_DECIMAL).put((Object)SqlBcEditFieldDTO_.edit_date1.getName(), (Object)SqlFieldType.TIME).put((Object)SqlBcEditFieldDTO_.edit_date2.getName(), (Object)SqlFieldType.TIME).put((Object)SqlBcEditFieldDTO_.edit_date3.getName(), (Object)SqlFieldType.TIME).put((Object)SqlBcEditFieldDTO_.edit_date4.getName(), (Object)SqlFieldType.TIME).put((Object)SqlBcEditFieldDTO_.edit_date5.getName(), (Object)SqlFieldType.TIME).build();
    private static final Map<Database, String> PAGING_QUERY_MAP = new ImmutableMap.Builder().put((Object)Database.POSTGRESQL, (Object)"select row_.*, ROW_NUMBER() OVER () rownum_ from (select * from (%s) as q1 %s) row_ %s LIMIT :to OFFSET :from").put((Object)Database.ORACLE, (Object)"select s.* from (select row_.*, rownum rownum_ from (select * from (%s)%s) row_ where rownum <= :to %s) s where rownum_ > :from").build();
    private static final Set<String> BOOLEAN_FILTER_TRUE_VALUES = Sets.newHashSet((Object[])new String[]{"TRUE", "T", "YES", "Y", "ON"});
    private static final Set<String> BOOLEAN_FILTER_FALSE_VALUES = Sets.newHashSet((Object[])new String[]{"FALSE", "F", "NO", "N", "OFF"});
    private final String query;
    private final String order;
    private final String filter;
    private final SqlParameterSource parameterSource;
    private final String bcName;
    private final Database database;

    public static Function<String, Object> getValueMapper(SqlBcDescription.Field field) {
        switch (field.getType()) {
            case STRING: {
                return TypeConverter::toString;
            }
            case BIG_DECIMAL: {
                return TypeConverter::toBigDecimal;
            }
            case BOOLEAN: {
                return TypeConverter::toBoolean;
            }
            case BYTE: {
                return TypeConverter::toByte;
            }
            case SHORT: {
                return TypeConverter::toShort;
            }
            case INTEGER: {
                return TypeConverter::toInteger;
            }
            case LONG: {
                return TypeConverter::toLong;
            }
            case FLOAT: {
                return TypeConverter::toFloat;
            }
            case DOUBLE: {
                return TypeConverter::toDouble;
            }
            case DATE: 
            case TIMESTAMP: {
                return field.isTzAware() ? TypeConverter::toSqlTimestampTzAware : TypeConverter::toSqlTimestamp;
            }
            case TIME: {
                return field.isTzAware() ? TypeConverter::toLocalDateTimeTzAware : TypeConverter::toLocalDateTime;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)field.getType()));
    }

    public static SqlBcQuery build(SessionService sessionService, SqlBcDescription bcDescription, String id, String parentId, QueryParameters queryParameters, Database database) {
        return new Builder(sessionService, bcDescription, id, parentId, queryParameters, database).build();
    }

    public String pageQuery() {
        return String.format(PAGING_QUERY_MAP.get(this.database), this.getInnerSelect(this.query, this.bcName), StringUtils.isNotBlank((CharSequence)this.order) ? " order by " + this.order : "", this.filter);
    }

    public String countQuery() {
        return String.format("select count(*) from (%s) sqlbc where 1 = 1 %s", this.query, this.filter);
    }

    public String idQuery() {
        return String.format("select * from (%s) sqlbc where id = :id", this.getInnerSelect(this.query, this.bcName));
    }

    private String getInnerSelect(String query, String bcName) {
        StringBuilder builder = new StringBuilder();
        builder.append("select sqlbc.*");
        for (String extra : EXTRA_FIELDS.keySet()) {
            builder.append(" ,");
            builder.append("f.").append(extra);
        }
        builder.append(" from (").append(query).append(") sqlbc ");
        builder.append("left join sql_bc_edit_field f ");
        builder.append("on f.parent_id = sqlbc.id and f.bc_name = ");
        builder.append("'").append(bcName).append("'");
        return builder.toString();
    }

    public SqlParameterSource parameterSource() {
        return this.parameterSource;
    }

    @ConstructorProperties(value={"query", "order", "filter", "parameterSource", "bcName", "database"})
    @Generated
    private SqlBcQuery(String query, String order, String filter, SqlParameterSource parameterSource, String bcName, Database database) {
        this.query = query;
        this.order = order;
        this.filter = filter;
        this.parameterSource = parameterSource;
        this.bcName = bcName;
        this.database = database;
    }

    private static final class Builder {
        private final SessionService sessionService;
        private final String query;
        private final StringBuilder order = new StringBuilder();
        private final StringBuilder filter = new StringBuilder();
        private final MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        private final String bcName;
        private final Database database;

        private Builder(SessionService sessionService, SqlBcDescription bcDescription, String id, String parentId, QueryParameters queryParameters, Database database) {
            this.sessionService = sessionService;
            this.query = bcDescription.getQuery();
            this.bcName = bcDescription.getName();
            this.database = database;
            this.fillParameterSource(id, parentId, queryParameters);
            this.fillOrder(bcDescription, queryParameters.getSort());
            this.fillFilter(bcDescription, queryParameters.getFilter());
            this.fillBinds(bcDescription, queryParameters.getBinds());
        }

        public SqlBcQuery build() {
            return new SqlBcQuery(this.query, this.order.toString(), this.filter.toString(), (SqlParameterSource)this.parameterSource, this.bcName, this.database);
        }

        private void fillParameterSource(String id, String parentId, QueryParameters queryParameters) {
            int from = queryParameters.getPageNumber() * queryParameters.getPageSize();
            int to = from + queryParameters.getPageSize() + 1;
            String userRole = Optional.ofNullable(this.sessionService.getSessionUserRole()).map(LOV::getKey).orElse("");
            this.parameterSource.addValue("userid", (Object)this.sessionService.getSessionUser().getId()).addValue("userrole", (Object)userRole).addValue("userdeptid", (Object)this.sessionService.getSessionUserDepartment().getId()).addValue("isfilterabledata", (Object)(queryParameters.isFilterableData() ? "Y" : "N")).addValue("parentid", (Object)parentId).addValue("datefrom", (Object)Timestamp.valueOf(queryParameters.getDateFrom())).addValue("dateto", (Object)Timestamp.valueOf(queryParameters.getDateTo())).addValue("datefrom_tzware", (Object)Timestamp.valueOf(queryParameters.getDateFrom().with(DateTimeUtil.fromSession()))).addValue("dateto_tzware", (Object)Timestamp.valueOf(queryParameters.getDateTo().with(DateTimeUtil.fromSession()))).addValue("timezone", (Object)TimeZoneUtil.getSessionZoneId()).addValue("language", (Object)LocaleContextHolder.getLocale().getLanguage()).addValue("from", (Object)from).addValue("to", (Object)to).addValue(SqlBcQuery.FIELD_ID, (Object)id);
        }

        private void fillBinds(SqlBcDescription bcDescription, BindsParameters bindParameters) {
            List parameters = bindParameters.getParameters();
            bcDescription.getBinds().forEach(bind -> {
                Optional<BindParameter> parameterOptional = parameters.stream().filter(p -> p.getSqlParameter().equals(bind.getBindName())).findFirst();
                if (bind.isExistInQuery(this.query)) {
                    if (parameterOptional.isPresent()) {
                        this.fillFoundBind(parameterOptional.get());
                    } else {
                        this.parameterSource.addValue(bind.getBindName(), null);
                    }
                }
            });
        }

        private void fillFoundBind(BindParameter parameter) {
            SearchOperation operation = parameter.getOperation();
            if (operation == null) {
                this.parameterSource.addValue(parameter.getName(), (Object)parameter.getStringValue());
                return;
            }
            switch (operation) {
                case EQUALS: 
                case GREATER_THAN: 
                case LESS_THAN: 
                case GREATER_OR_EQUAL_THAN: 
                case LESS_OR_EQUAL_THAN: 
                case CONTAINS: {
                    this.parameterSource.addValue(parameter.getSqlParameter(), (Object)parameter.getStringValue());
                    break;
                }
                case EQUALS_ONE_OF: 
                case CONTAINS_ONE_OF: {
                    this.parameterSource.addValue(parameter.getSqlParameter(), (Object)parameter.getStringValuesAsString());
                    break;
                }
                case SPECIFIED: 
                case SPECIFIED_BOOLEAN_SQL: {
                    this.parameterSource.addValue(parameter.getSqlParameter(), (Object)parameter.getBooleanValue());
                    break;
                }
                default: {
                    log.error("Unknown operation " + operation);
                }
            }
        }

        private void fillOrder(SqlBcDescription bcDescription, SortParameters sort) {
            if (sort != null && !sort.getParameters().isEmpty()) {
                List<SortParameter> sortedParams = sort.getParameters().stream().sorted(Comparator.comparingInt(SortParameter::getPriority)).collect(Collectors.toList());
                sortedParams.forEach(parameter -> this.order.append(parameter.getName()).append(' ').append(parameter.getType().name()).append(','));
            } else if (StringUtils.isNotBlank((CharSequence)bcDescription.getDefaultOrder())) {
                this.order.append(bcDescription.getDefaultOrder()).append(",");
            }
            this.order.append("id desc");
        }

        private void fillFilter(SqlBcDescription bcDescription, FilterParameters searchParameters) {
            int parameterNumber = 0;
            for (FilterParameter parameter : searchParameters) {
                String parameterName;
                SearchOperation operation = parameter.getOperation();
                SqlBcDescription.Field field = this.getField(bcDescription, parameter.getName());
                this.filter.append(" and ( ");
                if (SearchOperation.CONTAINS == operation) {
                    parameterName = this.createParameterName(++parameterNumber);
                    this.filter.append("upper(\"").append(field.getColumnName()).append("\") ");
                    this.filter.append("like upper(").append(":").append(parameterName).append(") ");
                    this.parameterSource.addValue(parameterName, (Object)("%" + parameter.getStringValue() + "%"));
                } else if (SearchOperation.EQUALS_ONE_OF == operation) {
                    this.filter.append(" ( ");
                    String prefix = field.getColumnName() + " IN (";
                    String postfix = ") )";
                    ArrayList<String> stringArrayList = new ArrayList<String>();
                    switch (field.getType()) {
                        case TIMESTAMP: {
                            Iterator dateValueAsList = parameter.getDateValueAsList().iterator();
                            while (dateValueAsList.hasNext()) {
                                this.filter.append("\"").append(field.getColumnName()).append("\"");
                                LocalDateTime value = (LocalDateTime)dateValueAsList.next();
                                Timestamp startValue = Timestamp.valueOf(value.with(DateTimeUtil.asStartOfDay()).with(DateTimeUtil.fromSession((boolean)field.isTzAware())));
                                Timestamp endValue = Timestamp.valueOf(value.with(DateTimeUtil.asEndOfDay()).with(DateTimeUtil.fromSession((boolean)field.isTzAware())));
                                String parameterNameStart = this.createParameterName(++parameterNumber);
                                this.filter.append(" >= :").append(parameterNameStart).append(" ");
                                this.parameterSource.addValue(parameterNameStart, (Object)startValue);
                                String parameterNameEnd = this.createParameterName(++parameterNumber);
                                this.filter.append("AND ").append("\"").append(field.getColumnName()).append("\"").append(" <= :").append(parameterNameEnd).append(" ");
                                this.parameterSource.addValue(parameterNameEnd, (Object)endValue);
                                if (dateValueAsList.hasNext()) {
                                    this.filter.append(" ) OR (");
                                    continue;
                                }
                                this.filter.append(" ) ");
                            }
                            break;
                        }
                        case STRING: {
                            String parameterName2;
                            for (Object value : parameter.getStringValuesAsList()) {
                                parameterName2 = this.createParameterName(++parameterNumber);
                                stringArrayList.add(":" + parameterName2);
                                this.parameterSource.addValue(parameterName2, value);
                            }
                            this.filter.append(prefix).append(StringUtils.join(stringArrayList, (String)",")).append(postfix);
                            break;
                        }
                        case BIG_DECIMAL: {
                            String parameterName2;
                            for (Object value : parameter.getBigDecimalValuesAsList()) {
                                parameterName2 = this.createParameterName(++parameterNumber);
                                stringArrayList.add(":" + parameterName2);
                                this.parameterSource.addValue(parameterName2, value);
                            }
                            this.filter.append(prefix).append(StringUtils.join(stringArrayList, (String)",")).append(postfix);
                            break;
                        }
                    }
                } else {
                    this.filter.append("\"").append(field.getColumnName()).append("\"");
                    if (SearchOperation.SPECIFIED == operation) {
                        this.filter.append(BooleanUtils.isNotFalse((Boolean)parameter.getBooleanValue()) ? " is not null " : " is null ");
                    } else if (SearchOperation.SPECIFIED_BOOLEAN_SQL == operation) {
                        this.filter.append(BooleanUtils.isTrue((Boolean)parameter.getBooleanValue()) ? String.format(" IS NOT NULL AND upper(%s) IN (%s) ", field.getColumnName(), "'" + String.join((CharSequence)"','", BOOLEAN_FILTER_TRUE_VALUES) + "'") : String.format(" IS NULL OR upper(%s) IN (%s) ", field.getColumnName(), "'" + String.join((CharSequence)"','", BOOLEAN_FILTER_FALSE_VALUES) + "'"));
                    } else {
                        if (SearchOperation.EQUALS == operation) {
                            this.filter.append(" = ");
                        } else if (SearchOperation.GREATER_THAN == operation) {
                            this.filter.append(" > ");
                        } else if (SearchOperation.GREATER_OR_EQUAL_THAN == operation) {
                            this.filter.append(" >= ");
                        } else if (SearchOperation.LESS_THAN == operation) {
                            this.filter.append(" < ");
                        } else if (SearchOperation.LESS_OR_EQUAL_THAN == operation) {
                            this.filter.append(" <= ");
                        }
                        parameterName = this.createParameterName(++parameterNumber);
                        this.filter.append(":").append(parameterName).append(" ");
                        Function<String, Object> mapper = SqlBcQuery.getValueMapper(field);
                        this.parameterSource.addValue(parameterName, mapper.apply(parameter.getStringValue()));
                    }
                }
                this.filter.append(" ) ");
            }
        }

        private String createParameterName(int number) {
            return "p_" + number;
        }

        private SqlBcDescription.Field getField(SqlBcDescription bcDescription, String fieldName) {
            return bcDescription.getFields().stream().filter(f -> f.getFieldName().equals(fieldName)).findFirst().orElseThrow(() -> new ClientException(String.format("\u041f\u043e\u043b\u0435 %s \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", fieldName)));
        }
    }
}

