/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.crudma;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tesler.api.data.ResultPage;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.data.dto.rowmeta.FieldDTO;
import io.tesler.api.data.dto.rowmeta.FieldsDTO;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.controller.param.DateStep;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.AbstractCrudmaService;
import io.tesler.core.dto.data.SqlBcEditFieldDTO;
import io.tesler.core.dto.data.SqlBcEditFieldDTO_;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.ActionsDTO;
import io.tesler.core.dto.rowmeta.EngineFieldsMeta;
import io.tesler.core.dto.rowmeta.MetaDTO;
import io.tesler.core.dto.rowmeta.RowMetaDTO;
import io.tesler.core.dto.rowmeta.SQLMetaDTO;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.service.ResponseFactory;
import io.tesler.core.service.action.ActionDescription;
import io.tesler.core.service.action.Actions;
import io.tesler.core.service.action.ActionsBuilder;
import io.tesler.core.service.linkedlov.LinkedDictionaryService;
import io.tesler.core.ui.BcUtils;
import io.tesler.core.util.DateTimeUtil;
import io.tesler.core.util.session.SessionService;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.ui.entity.SqlBcEditField;
import io.tesler.model.ui.entity.SqlBcEditField_;
import io.tesler.sqlbc.crudma.SqlBcAction;
import io.tesler.sqlbc.crudma.SqlBcDescription;
import io.tesler.sqlbc.crudma.SqlComponentObject;
import io.tesler.sqlbc.dao.SqlBcQuery;
import io.tesler.sqlbc.dao.SqlComponentDao;
import io.tesler.sqlbc.dao.binds.SqlNamedParameterQueryBinder;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SqlCrudmaService
extends AbstractCrudmaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlCrudmaService.class);
    private final SqlComponentDao sqlComponentDao;
    private final ResponseFactory respFactory;
    private final JpaDao jpaDao;
    private final Optional<List<SqlBcAction>> sqlBcActions;
    private final Optional<LinkedDictionaryService> linkedDictionaryService;
    private final BcUtils bcUtils;
    private final SessionService sessionService;
    private final SqlNamedParameterQueryBinder sqlNamedParameterQueryBinder;
    @Qualifier(value="teslerObjectMapper")
    private final ObjectMapper objectMapper;
    @Qualifier(value="primaryDatabase")
    private final Database primaryDatabase;

    public SqlComponentObject get(BusinessComponent bc) {
        try {
            return this.sqlComponentDao.getOne(bc, bc.getParameters());
        }
        catch (NoResultException ex) {
            throw new BusinessException().addPopup(ex.getMessage());
        }
    }

    public ResultPage<SqlComponentObject> getAll(BusinessComponent bc) {
        ResultPage<SqlComponentObject> page = this.sqlComponentDao.getPage(bc, bc.getParameters());
        String fieldName = ((SqlBcDescription)bc.getDescription()).getReportDateField();
        this.checkPivotFilters(page, bc.getParameters(), fieldName);
        return page;
    }

    public ActionResultDTO update(BusinessComponent bc, Map<String, Object> data) {
        SqlBcEditFieldDTO dto = (SqlBcEditFieldDTO)this.respFactory.getDTOFromMap(data, SqlBcEditFieldDTO.class, bc);
        SqlBcDescription sqlBcDesc = (SqlBcDescription)bc.getDescription();
        SqlBcEditField sqlBcEditField = this.jpaDao.getList(SqlBcEditField.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(SqlBcEditField_.parentId), (Object)bc.getId()), (Expression)cb.equal((Expression)root.get(SqlBcEditField_.bcName), (Object)sqlBcDesc.getName()))).stream().findFirst().orElseGet(() -> {
            SqlBcEditField result = new SqlBcEditField();
            result.setParentId(bc.getId());
            result.setBcName(sqlBcDesc.getName());
            return result;
        });
        if (dto.hasChangedFields()) {
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string1)) {
                sqlBcEditField.setEditString1(dto.getEdit_string1());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string2)) {
                sqlBcEditField.setEditString2(dto.getEdit_string2());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string3)) {
                sqlBcEditField.setEditString3(dto.getEdit_string3());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string4)) {
                sqlBcEditField.setEditString4(dto.getEdit_string4());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string5)) {
                sqlBcEditField.setEditString5(dto.getEdit_string5());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string6)) {
                sqlBcEditField.setEditString6(dto.getEdit_string6());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string7)) {
                sqlBcEditField.setEditString7(dto.getEdit_string7());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string8)) {
                sqlBcEditField.setEditString8(dto.getEdit_string8());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string9)) {
                sqlBcEditField.setEditString9(dto.getEdit_string9());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_string10)) {
                sqlBcEditField.setEditString10(dto.getEdit_string10());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_number1)) {
                sqlBcEditField.setEditNumber1(Integer.valueOf(dto.getEdit_number1().intValue()));
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_number2)) {
                sqlBcEditField.setEditNumber2(Integer.valueOf(dto.getEdit_number2().intValue()));
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_number3)) {
                sqlBcEditField.setEditNumber3(Integer.valueOf(dto.getEdit_number3().intValue()));
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_number4)) {
                sqlBcEditField.setEditNumber4(Integer.valueOf(dto.getEdit_number4().intValue()));
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_number5)) {
                sqlBcEditField.setEditNumber5(Integer.valueOf(dto.getEdit_number5().intValue()));
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_date1)) {
                sqlBcEditField.setEditDate1(dto.getEdit_date1());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_date2)) {
                sqlBcEditField.setEditDate2(dto.getEdit_date2());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_date3)) {
                sqlBcEditField.setEditDate3(dto.getEdit_date3());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_date4)) {
                sqlBcEditField.setEditDate4(dto.getEdit_date4());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_date5)) {
                sqlBcEditField.setEditDate5(dto.getEdit_date5());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_lov1)) {
                sqlBcEditField.setEditLov1(dto.getEdit_lov1());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_lov2)) {
                sqlBcEditField.setEditLov2(dto.getEdit_lov2());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_lov3)) {
                sqlBcEditField.setEditLov3(dto.getEdit_lov3());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_lov4)) {
                sqlBcEditField.setEditLov4(dto.getEdit_lov4());
            }
            if (dto.isFieldChanged(SqlBcEditFieldDTO_.edit_lov5)) {
                sqlBcEditField.setEditLov5(dto.getEdit_lov5());
            }
        }
        this.jpaDao.save((Object)sqlBcEditField);
        SqlBcEditFieldDTO sqlBcEditFieldDTO = new SqlBcEditFieldDTO(sqlBcEditField);
        sqlBcEditFieldDTO.setId(bc.getId());
        return new ActionResultDTO((DataResponseDTO)sqlBcEditFieldDTO);
    }

    private void checkPivotFilters(ResultPage<SqlComponentObject> page, QueryParameters queryParameters, String fieldName) {
        LocalDateTime dateTo = queryParameters.getDateTo();
        LocalDateTime dateFrom = queryParameters.getDateFrom();
        DateStep dateStep = queryParameters.getDateStep();
        if (fieldName != null && dateFrom != null && dateTo != null) {
            Month monthFrom = dateFrom.getMonth();
            List result = page.getResult();
            result.removeIf(sqlComponent -> {
                LocalDateTime componentDate = this.getDate((SqlComponentObject)((Object)sqlComponent), fieldName);
                int dayOfMonth = componentDate.getDayOfMonth();
                Month month = componentDate.getMonth();
                Month firstMonthOfQuarter = month.firstMonthOfQuarter();
                boolean isFirstMonthOfQuarter = firstMonthOfQuarter.equals(month);
                boolean isNotInPeriod = componentDate.isAfter(dateTo) || componentDate.isBefore(dateFrom);
                boolean isNotInPeriodYear = componentDate.isAfter(dateTo) || componentDate.isBefore(dateFrom.withDayOfMonth(1));
                switch (dateStep) {
                    case YEAR: {
                        return isNotInPeriodYear || dayOfMonth != 1 || !month.equals(monthFrom);
                    }
                    case QUARTER: {
                        return isNotInPeriod || dayOfMonth != 1 || !isFirstMonthOfQuarter;
                    }
                    case MONTH: {
                        return isNotInPeriod || dayOfMonth != 1;
                    }
                }
                return isNotInPeriod;
            });
        }
    }

    private LocalDateTime getDate(SqlComponentObject sqlComponent, String fieldName) {
        return DateTimeUtil.toLocalDateTime((Date)((Date)sqlComponent.get(fieldName)));
    }

    private SQLMetaDTO buildMeta(BusinessComponent bc, List<FieldDTO> fields, ActionsDTO actions) {
        SQLMetaDTO metaDTO = new SQLMetaDTO(new RowMetaDTO(actions, FieldsDTO.of(fields)));
        if (bc.getParameters().isDebug()) {
            this.setDebugParameters(bc, metaDTO);
        }
        return metaDTO;
    }

    public SQLMetaDTO getMeta(BusinessComponent bc) {
        Set fieldsForCurrentScreen = this.bcUtils.getBcFieldsForCurrentScreen((BcIdentifier)bc);
        List<FieldDTO> fields = ((SqlBcDescription)bc.getDescription()).getFields().stream().filter(field -> fieldsForCurrentScreen.contains(field.getFieldName())).map(field -> field.getEditable() != false && this.isActionSaveAvailable(bc) ? FieldDTO.enabledField((String)field.getFieldName()) : FieldDTO.disabledFilterableField((String)field.getFieldName())).collect(Collectors.toList());
        EngineFieldsMeta meta = new EngineFieldsMeta(this.objectMapper);
        fields.forEach(arg_0 -> ((EngineFieldsMeta)meta).add(arg_0));
        this.linkedDictionaryService.ifPresent(linkedDictSrvc -> linkedDictSrvc.fillRowMetaWithLinkedDictionaries(meta, bc, false));
        return this.buildMeta(bc, fields, this.getActions().toDto(bc));
    }

    public MetaDTO getMetaEmpty(BusinessComponent bc) {
        return this.buildMeta(bc, Collections.emptyList(), this.getActions().toDto(bc));
    }

    public long count(BusinessComponent bc) {
        return this.sqlComponentDao.count(bc, bc.getParameters());
    }

    public ActionResultDTO invokeAction(BusinessComponent bc, String actionName, Map<String, Object> data) {
        SqlComponentObject dto = this.getAll(bc).getResult().stream().filter(object -> Objects.equals(object.getId(), bc.getId())).findFirst().orElse(null);
        ActionDescription action = this.getActions().getAction(actionName);
        if (action == null || !action.isAvailable(bc)) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.action_unavailable", (Object[])new Object[]{actionName}));
        }
        return action.invoke(bc, (DataResponseDTO)dto);
    }

    private Actions<SqlComponentObject> getActions() {
        ActionsBuilder builder = Actions.builder();
        this.sqlBcActions.ifPresent(sqlBcActions -> {
            for (SqlBcAction action : sqlBcActions) {
                builder.action(action.getKey(), action.getText()).available(action::isAvailable).invoker(action::invoke).add();
            }
        });
        return builder.save().available(this::isActionSaveAvailable).add().build();
    }

    private boolean isActionSaveAvailable(BusinessComponent bc) {
        return ((SqlBcDescription)bc.getDescription()).isEditable();
    }

    private void setDebugParameters(BusinessComponent bc, SQLMetaDTO metaDTO) {
        SqlBcDescription description = (SqlBcDescription)bc.getDescription();
        metaDTO.setQuery(description.getQuery());
        try {
            SqlBcQuery query = SqlBcQuery.build(this.sessionService, description, bc.getId(), bc.getParentId(), bc.getParameters(), this.primaryDatabase);
            String preparedQuery = this.sqlNamedParameterQueryBinder.bindVariables(query.pageQuery(), query.parameterSource());
            metaDTO.setPreparedQuery(preparedQuery);
        }
        catch (Exception exc) {
            log.error("Exception while binding parameters to sql", (Throwable)exc);
        }
    }

    @ConstructorProperties(value={"sqlComponentDao", "respFactory", "jpaDao", "sqlBcActions", "linkedDictionaryService", "bcUtils", "sessionService", "sqlNamedParameterQueryBinder", "objectMapper", "primaryDatabase"})
    @Generated
    public SqlCrudmaService(SqlComponentDao sqlComponentDao, ResponseFactory respFactory, JpaDao jpaDao, Optional<List<SqlBcAction>> sqlBcActions, Optional<LinkedDictionaryService> linkedDictionaryService, BcUtils bcUtils, SessionService sessionService, SqlNamedParameterQueryBinder sqlNamedParameterQueryBinder, @Qualifier(value="teslerObjectMapper") ObjectMapper objectMapper, @Qualifier(value="primaryDatabase") Database primaryDatabase) {
        this.sqlComponentDao = sqlComponentDao;
        this.respFactory = respFactory;
        this.jpaDao = jpaDao;
        this.sqlBcActions = sqlBcActions;
        this.linkedDictionaryService = linkedDictionaryService;
        this.bcUtils = bcUtils;
        this.sessionService = sessionService;
        this.sqlNamedParameterQueryBinder = sqlNamedParameterQueryBinder;
        this.objectMapper = objectMapper;
        this.primaryDatabase = primaryDatabase;
    }
}

