/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.sqlbc.crudma;

import io.tesler.api.service.AsyncService;
import io.tesler.api.service.tx.TransactionService;
import io.tesler.api.util.Invoker;
import io.tesler.api.util.privileges.PrivilegeUtil;
import io.tesler.core.crudma.bc.RefreshableBcSupplier;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.ui.entity.Bc;
import io.tesler.sqlbc.crudma.SqlBcCreator;
import io.tesler.sqlbc.crudma.SqlBcDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"deploymentTransactionSupport"})
@Service
public final class SqlBcSupplier
implements RefreshableBcSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlBcSupplier.class);
    private final AsyncService asyncService;
    private final TransactionService txService;
    private final JpaDao jpaDao;
    private final SqlBcCreator sqlBcCreator;
    private Map<String, SqlBcDescription> sqlBcMap;

    public SqlBcSupplier(AsyncService asyncService, TransactionService txService, JpaDao jpaDao, SqlBcCreator sqlBcCreator) {
        this.asyncService = asyncService;
        this.txService = txService;
        this.jpaDao = jpaDao;
        this.sqlBcCreator = sqlBcCreator;
        this.sqlBcMap = this.loadAllBcNames();
        this.loadData(true);
    }

    public BcDescription getBcDescription(String bcName) {
        return this.sqlBcMap.get(bcName);
    }

    private void loadData(boolean startup) {
        PrivilegeUtil.runPrivileged(() -> this.asyncService.invokeAsync(() -> (Void)this.txService.invokeInTx(Invoker.of(() -> this.doLoadData(startup)))));
    }

    private void doLoadData(boolean startup) {
        this.sqlBcMap.forEach((name, desc) -> {
            try {
                desc.getFields();
            }
            catch (Exception ex) {
                if (startup) {
                    log.error(ex.getLocalizedMessage());
                }
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        });
    }

    public List<String> getAllBcNames() {
        return new ArrayList<String>(this.sqlBcMap.keySet());
    }

    public void refresh() {
        this.sqlBcMap = this.loadAllBcNames();
        this.loadData(false);
    }

    private Map<String, SqlBcDescription> loadAllBcNames() {
        return this.jpaDao.getList(Bc.class).stream().map(this.sqlBcCreator::getDescription).collect(Collectors.toMap(BcDescription::getName, Function.identity()));
    }
}

