/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.unload;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tesler.db.migration.liquibase.data.WidgetEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.change.DatabaseChange;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.tesler.ui.unload.AbstractEntityUnload;
import org.apache.commons.lang3.StringUtils;

@DatabaseChange(name="widgetunload", description="Unload widgets", priority=1)
public class WidgetUnload
extends AbstractEntityUnload {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void unload(JdbcConnection connection) throws Exception {
        ObjectMapper mapper = this.createMapper();
        try (PreparedStatement statement = connection.prepareStatement("SELECT WIDGET.*, BC.ID AS BC_ID FROM WIDGET, BC WHERE WIDGET.BC=BC.NAME(+)");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                FileOutputStream fos;
                block35: {
                    WidgetEntity widgetEntity = new WidgetEntity();
                    widgetEntity.setName(resultSet.getString("NAME"));
                    if (StringUtils.isBlank((CharSequence)widgetEntity.getName())) {
                        widgetEntity.setId(resultSet.getLong("ID"));
                    }
                    widgetEntity.setBc(resultSet.getString("BC"));
                    widgetEntity.setType(resultSet.getString("TYPE"));
                    widgetEntity.setTitle(resultSet.getString("TITLE"));
                    widgetEntity.setTemplate(resultSet.getString("TEMPLATE"));
                    widgetEntity.setAxisFields(this.asJson(mapper, resultSet, "AXIS_FIELDS"));
                    widgetEntity.setChart(this.asJson(mapper, resultSet, "CHART"));
                    widgetEntity.setFields(this.asJson(mapper, resultSet, "FIELDS"));
                    widgetEntity.setGraph(this.asJson(mapper, resultSet, "GRAPH"));
                    widgetEntity.setOptions(this.asJson(mapper, resultSet, "OPTIONS"));
                    widgetEntity.setPivotFields(this.asJson(mapper, resultSet, "PIVOT_FIELDS"));
                    widgetEntity.setShowCondition(this.asJson(mapper, resultSet, "SHOW_CONDITION"));
                    File destination = resultSet.getBigDecimal("BC_ID") != null ? this.buildDirectory("sqlbc", widgetEntity.getBc()) : this.buildDirectory("widgets");
                    String fileName = StringUtils.isNotBlank((CharSequence)widgetEntity.getName()) ? String.format("%s.widget.json", widgetEntity.getName()) : String.format("%06d.widget.json", widgetEntity.getId());
                    fos = new FileOutputStream(new File(destination, fileName));
                    Throwable throwable = null;
                    try {
                        mapper.writeValue((OutputStream)fos, (Object)widgetEntity);
                        if (fos == null) continue;
                        if (throwable == null) break block35;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }
}

