/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.unload;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.tesler.db.migration.liquibase.data.BcEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.change.DatabaseChange;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.tesler.ui.unload.AbstractEntityUnload;

@DatabaseChange(name="bcunload", description="Unload bcs", priority=1)
public class BcUnload
extends AbstractEntityUnload {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void unload(JdbcConnection connection) throws Exception {
        ObjectMapper mapper = this.createMapper();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM BC");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                FileOutputStream fos;
                block52: {
                    Throwable throwable;
                    BigDecimal pageLimit;
                    BcEntity bcEntity = new BcEntity();
                    bcEntity.setName(resultSet.getString("NAME"));
                    bcEntity.setParentName(resultSet.getString("PARENT_NAME"));
                    bcEntity.setDefaultOrder(resultSet.getString("DEFAULT_ORDER"));
                    JsonNode binds = this.asJson(mapper, resultSet, "BINDS");
                    if (binds != null && binds.size() > 0) {
                        bcEntity.setBinds(binds);
                    }
                    bcEntity.setReportDateField(resultSet.getString("REPORT_DATE_FIELD"));
                    BigDecimal editable = resultSet.getBigDecimal("EDITABLE");
                    if (editable != null && editable.compareTo(new BigDecimal(0)) != 0) {
                        bcEntity.setEditable(editable.longValue());
                    }
                    if (BigDecimal.ONE.equals(resultSet.getBigDecimal("REFRESH"))) {
                        bcEntity.setRefresh(1L);
                    }
                    if ((pageLimit = resultSet.getBigDecimal("PAGE_LIMIT")) != null && pageLimit.compareTo(new BigDecimal(5)) != 0) {
                        bcEntity.setPageLimit(pageLimit.longValue());
                    }
                    String query = resultSet.getString("QUERY");
                    File destination = this.buildDirectory("sqlbc", bcEntity.getName());
                    if (query != null) {
                        fos = new FileOutputStream(new File(destination, String.format("%s.sqlbc.sql", bcEntity.getName())));
                        throwable = null;
                        try {
                            fos.write(query.getBytes());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fos != null) {
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    fos.close();
                                }
                            }
                        }
                        bcEntity.setQueryFile(String.format("db/migration/liquidbase/data/latest/sqlbc/%s/%s.sqlbc.sql", bcEntity.getName(), bcEntity.getName()));
                    }
                    fos = new FileOutputStream(new File(destination, String.format("%s.sqlbc.json", bcEntity.getName())));
                    throwable = null;
                    try {
                        mapper.writeValue((OutputStream)fos, (Object)bcEntity);
                        if (fos == null) continue;
                        if (throwable == null) break block52;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (fos == null) throw throwable5;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                            fos.close();
                            throw throwable5;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }
}

