/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.unload;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.sql.ResultSet;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public abstract class AbstractEntityUnload
implements CustomTaskChange {
    public static final String RELATIVE_PATH = "db/migration/liquidbase/data/latest";
    private String path;

    @DatabaseChangeProperty(description="Directory to place JSON files")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected File buildDirectory(String ... children) {
        File file = new File(this.getPath());
        for (String part : RELATIVE_PATH.split("/")) {
            file = new File(file, part);
        }
        for (String part : children) {
            file = new File(file, part);
        }
        file.mkdirs();
        return file;
    }

    public void execute(Database database) throws CustomChangeException {
        try {
            JdbcConnection connection = (JdbcConnection)database.getConnection();
            this.unload(connection);
        }
        catch (Exception ex) {
            throw new CustomChangeException((Throwable)ex);
        }
    }

    protected abstract void unload(JdbcConnection var1) throws Exception;

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    protected JsonNode asJson(ObjectMapper mapper, ResultSet resultSet, String column) throws Exception {
        String data = resultSet.getString(column);
        if (data != null) {
            return mapper.readTree(data);
        }
        return null;
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }
}

