/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.stmt;

import io.tesler.db.migration.liquibase.util.ColumnUtils;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.UpdateExecutablePreparedStatement;
import liquibase.util.SqlUtil;

public class UpdatePreparedStatement
extends UpdateExecutablePreparedStatement {
    public UpdatePreparedStatement(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        super(database, catalogName, schemaName, tableName, ColumnUtils.normalizeLobs(columns, changeSet, resourceAccessor), changeSet, resourceAccessor);
    }

    protected String generateSql(List<ColumnConfig> cols) {
        StringBuilder sql = new StringBuilder("UPDATE ").append(this.database.escapeTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
        StringBuilder params = new StringBuilder(" SET ");
        for (ColumnConfig column : this.getColumns()) {
            params.append(this.database.escapeColumnName(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName()));
            params.append(" = ");
            Object value = column.getValueObject();
            if (value instanceof DatabaseFunction) {
                params.append(this.database.generateDatabaseFunctionValue((DatabaseFunction)value));
                params.append(", ");
                continue;
            }
            params.append("?, ");
            cols.add(column);
        }
        params.deleteCharAt(params.lastIndexOf(" "));
        params.deleteCharAt(params.lastIndexOf(","));
        sql.append((CharSequence)params);
        if (this.getWhereClause() != null) {
            sql.append(" WHERE ").append(SqlUtil.replacePredicatePlaceholders((Database)this.database, (String)this.getWhereClause(), (List)this.getWhereColumnNames(), (List)this.getWhereParameters()));
        }
        return sql.toString();
    }
}

