/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.db.migration.liquibase.util;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.util.file.FilenameUtils;

public final class ColumnUtils {
    private ColumnUtils() {
    }

    public static boolean hasBlobs(List<ColumnConfig> columns) {
        for (ColumnConfig columnConfig : columns) {
            if (!ColumnUtils.hasBlobs(columnConfig)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBlobs(ColumnConfig column) {
        return column.getValueBlobFile() != null || column.getValueClobFile() != null;
    }

    public static List<ColumnConfig> normalizeLobs(List<ColumnConfig> columnConfigs, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        for (ColumnConfig columnConfig : columnConfigs) {
            ColumnUtils.normalizeLobs(columnConfig, changeSet, resourceAccessor);
        }
        return columnConfigs;
    }

    public static List<ColumnConfig> normalizeLobs(List<ColumnConfig> columnConfigs, AbstractChange change) {
        for (ColumnConfig columnConfig : columnConfigs) {
            ColumnUtils.normalizeLobs(columnConfig, change.getChangeSet(), change.getResourceAccessor());
        }
        return columnConfigs;
    }

    public static void normalizeLobs(ColumnConfig columnConfig, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        try {
            String changeLog = changeSet.getChangeLog().getPhysicalFilePath();
            columnConfig.setValueBlobFile(ColumnUtils.getRelativePath(resourceAccessor, columnConfig.getValueBlobFile(), changeLog));
            columnConfig.setValueClobFile(ColumnUtils.getRelativePath(resourceAccessor, columnConfig.getValueClobFile(), changeLog));
        }
        catch (IOException ex) {
            throw new UnexpectedLiquibaseException((Throwable)ex);
        }
    }

    private static String getRelativePath(ResourceAccessor resourceAccessor, String path, String changeLogPath) throws IOException {
        if (path == null) {
            return null;
        }
        Set candidates = resourceAccessor.list(changeLogPath, path, true, false, false);
        if (candidates != null && !candidates.isEmpty()) {
            return path;
        }
        candidates = resourceAccessor.list(null, path, true, false, false);
        if (candidates == null || candidates.isEmpty()) {
            return path;
        }
        int slashCount = FilenameUtils.getFullPath((String)changeLogPath).split("/").length;
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < slashCount; ++i) {
            pathBuilder.append("../");
        }
        pathBuilder.append(path);
        return pathBuilder.toString();
    }
}

