/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.tesler.liquibase;

import io.tesler.db.migration.liquibase.spring.SpringLiquibase;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import liquibase.change.DatabaseChange;
import liquibase.exception.LiquibaseException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.NamedParameterJdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.SchemaManagement;
import org.springframework.boot.jdbc.SchemaManagementProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={SpringLiquibase.class, DatabaseChange.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class LiquibaseAutoConfiguration {
    @Bean
    public LiquibaseSchemaManagementProvider liquibaseDefaultDdlModeProvider(ObjectProvider<liquibase.integration.spring.SpringLiquibase> liquibases) {
        return new LiquibaseSchemaManagementProvider(liquibases);
    }

    class LiquibaseSchemaManagementProvider
    implements SchemaManagementProvider {
        private final Iterable<liquibase.integration.spring.SpringLiquibase> liquibaseInstances;

        LiquibaseSchemaManagementProvider(ObjectProvider<liquibase.integration.spring.SpringLiquibase> liquibases) {
            this.liquibaseInstances = liquibases;
        }

        public SchemaManagement getSchemaManagement(DataSource dataSource) {
            return StreamSupport.stream(this.liquibaseInstances.spliterator(), false).map(liquibase.integration.spring.SpringLiquibase::getDataSource).filter(dataSource::equals).findFirst().map(managedDataSource -> SchemaManagement.MANAGED).orElse(SchemaManagement.UNMANAGED);
        }
    }

    public static class DataSourceClosingSpringLiquibase
    extends SpringLiquibase
    implements DisposableBean {
        private volatile boolean closeDataSourceOnceMigrated = true;

        public void setCloseDataSourceOnceMigrated(boolean closeDataSourceOnceMigrated) {
            this.closeDataSourceOnceMigrated = closeDataSourceOnceMigrated;
        }

        public void afterPropertiesSet() throws LiquibaseException {
            super.afterPropertiesSet();
            if (this.closeDataSourceOnceMigrated) {
                this.closeDataSource();
            }
        }

        private void closeDataSource() {
            Class<?> dataSourceClass = this.getDataSource().getClass();
            Method closeMethod = ReflectionUtils.findMethod(dataSourceClass, (String)"close");
            if (closeMethod != null) {
                ReflectionUtils.invokeMethod((Method)closeMethod, (Object)this.getDataSource());
            }
        }

        public void destroy() throws Exception {
            if (!this.closeDataSourceOnceMigrated) {
                this.closeDataSource();
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
    @ConditionalOnBean(value={NamedParameterJdbcOperations.class})
    protected static class LiquibaseNamedParameterJdbcOperationsDependencyConfiguration
    extends NamedParameterJdbcOperationsDependsOnPostProcessor {
        public LiquibaseNamedParameterJdbcOperationsDependencyConfiguration() {
            super(new String[]{"liquibase"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={JdbcOperations.class})
    @ConditionalOnBean(value={JdbcOperations.class})
    protected static class LiquibaseJdbcOperationsDependencyConfiguration
    extends JdbcOperationsDependsOnPostProcessor {
        public LiquibaseJdbcOperationsDependencyConfiguration() {
            super(new String[]{"liquibase"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class LiquibaseJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public LiquibaseJpaDependencyConfiguration() {
            super(new String[]{"liquibase"});
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @EnableConfigurationProperties(value={DataSourceProperties.class, LiquibaseProperties.class})
    @Import(value={LiquibaseJpaDependencyConfiguration.class})
    public static class LiquibaseConfiguration {
        private final LiquibaseProperties properties;
        private final DataSourceProperties dataSourceProperties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource liquibaseDataSource;

        public LiquibaseConfiguration(LiquibaseProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource) {
            this.properties = properties;
            this.dataSourceProperties = dataSourceProperties;
            this.resourceLoader = resourceLoader;
            this.dataSource = (DataSource)dataSource.getIfUnique();
            this.liquibaseDataSource = (DataSource)liquibaseDataSource.getIfAvailable();
        }

        @Bean
        public SpringLiquibase liquibase() {
            SpringLiquibase liquibase = this.createSpringLiquibase();
            liquibase.setChangeLog(this.properties.getChangeLog());
            liquibase.setContexts(this.properties.getContexts());
            liquibase.setDefaultSchema(this.properties.getDefaultSchema());
            liquibase.setLiquibaseSchema(this.properties.getLiquibaseSchema());
            liquibase.setLiquibaseTablespace(this.properties.getLiquibaseTablespace());
            liquibase.setDatabaseChangeLogTable(this.properties.getDatabaseChangeLogTable());
            liquibase.setDatabaseChangeLogLockTable(this.properties.getDatabaseChangeLogLockTable());
            liquibase.setDropFirst(this.properties.isDropFirst());
            liquibase.setShouldRun(this.properties.isEnabled());
            liquibase.setLabels(this.properties.getLabels());
            liquibase.setChangeLogParameters(this.properties.getParameters());
            liquibase.setRollbackFile(this.properties.getRollbackFile());
            liquibase.setTestRollbackOnUpdate(this.properties.isTestRollbackOnUpdate());
            return liquibase;
        }

        private SpringLiquibase createSpringLiquibase() {
            DataSource liquibaseDataSource = this.getDataSource();
            if (liquibaseDataSource != null) {
                SpringLiquibase liquibase = new SpringLiquibase();
                liquibase.setDataSource(liquibaseDataSource);
                return liquibase;
            }
            DataSourceClosingSpringLiquibase liquibase = new DataSourceClosingSpringLiquibase();
            liquibase.setDataSource(this.createNewDataSource());
            return liquibase;
        }

        private DataSource getDataSource() {
            if (this.liquibaseDataSource != null) {
                return this.liquibaseDataSource;
            }
            if (this.properties.getUrl() == null && this.properties.getUser() == null) {
                return this.dataSource;
            }
            return null;
        }

        private DataSource createNewDataSource() {
            String url = this.getProperty(() -> ((LiquibaseProperties)this.properties).getUrl(), () -> ((DataSourceProperties)this.dataSourceProperties).determineUrl());
            String user = this.getProperty(() -> ((LiquibaseProperties)this.properties).getUser(), () -> ((DataSourceProperties)this.dataSourceProperties).determineUsername());
            String password = this.getProperty(() -> ((LiquibaseProperties)this.properties).getPassword(), () -> ((DataSourceProperties)this.dataSourceProperties).determinePassword());
            return DataSourceBuilder.create().url(url).username(user).password(password).build();
        }

        private String getProperty(Supplier<String> property, Supplier<String> defaultValue) {
            String value = property.get();
            return value != null ? value : defaultValue.get();
        }
    }
}

