/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.stmt;

import io.tesler.db.migration.liquibase.util.ColumnUtils;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.InsertExecutablePreparedStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;

public class InsertPreparedStatement
extends InsertExecutablePreparedStatement {
    public InsertPreparedStatement(Database database, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        super(database, null, null, tableName, columns, changeSet, resourceAccessor);
    }

    public InsertPreparedStatement(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        super(database, catalogName, schemaName, tableName, ColumnUtils.normalizeLobs(columns, changeSet, resourceAccessor), changeSet, resourceAccessor);
    }

    public SqlStatement simplify() {
        if (ColumnUtils.hasBlobs(this.getColumns())) {
            return this;
        }
        InsertStatement statement = new InsertStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.getColumns()) {
            if (this.database.supportsAutoIncrement() && Boolean.TRUE.equals(column.isAutoIncrement() != null)) continue;
            statement.addColumnValue(column.getName(), column.getValueObject());
        }
        return statement;
    }

    protected String generateSql(List<ColumnConfig> cols) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        StringBuilder params = new StringBuilder("VALUES(");
        sql.append(this.database.escapeTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
        sql.append("(");
        for (ColumnConfig column : this.getColumns()) {
            if (this.database.supportsAutoIncrement() && Boolean.TRUE.equals(column.isAutoIncrement())) continue;
            sql.append(this.database.escapeColumnName(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName()));
            sql.append(", ");
            Object value = column.getValueObject();
            if (value instanceof DatabaseFunction) {
                params.append(this.database.generateDatabaseFunctionValue((DatabaseFunction)value));
                params.append(", ");
                continue;
            }
            params.append("?, ");
            cols.add(column);
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        sql.deleteCharAt(sql.lastIndexOf(","));
        params.deleteCharAt(params.lastIndexOf(" "));
        params.deleteCharAt(params.lastIndexOf(","));
        params.append(")");
        sql.append(") ");
        sql.append((CharSequence)params);
        return sql.toString();
    }
}

