/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.core;

import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.UpdateDataChange;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.ext.tesler.stmt.UpdatePreparedStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;

@DatabaseChange(name="update", description="Updates data in an existing table", priority=0x7FFFFFFF)
public class UpdateDataChangeCustom
extends UpdateDataChange {
    public SqlStatement[] generateStatements(Database database) {
        Object statement;
        boolean needsPreparedStatement = false;
        for (ColumnConfig column : this.getColumns()) {
            if (column.getValueBlobFile() != null) {
                needsPreparedStatement = true;
            }
            if (column.getValueClobFile() != null) {
                needsPreparedStatement = true;
            }
            if (!(database instanceof OracleDatabase) || column.getType() == null || !"CLOB".equalsIgnoreCase(column.getType()) || column.getValue() == null || column.getValue().length() < 4000) continue;
            needsPreparedStatement = true;
        }
        if (needsPreparedStatement) {
            statement = new UpdatePreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumns(), this.getChangeSet(), this.getResourceAccessor());
            statement.setWhereClause(this.where);
            for (ColumnConfig whereParam : this.whereParams) {
                if (whereParam.getName() != null) {
                    statement.addWhereColumnName(whereParam.getName());
                }
                statement.addWhereParameter(whereParam.getValueObject());
            }
            return new SqlStatement[]{statement};
        }
        statement = new UpdateStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.getColumns()) {
            statement.addNewColumnValue(column.getName(), column.getValueObject());
        }
        statement.setWhereClause(this.where);
        for (ColumnConfig whereParam : this.whereParams) {
            if (whereParam.getName() != null) {
                statement.addWhereColumnName(whereParam.getName());
            }
            statement.addWhereParameter(whereParam.getValueObject());
        }
        return new SqlStatement[]{statement};
    }
}

