/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.db.migration.liquibase.data;

import io.tesler.db.migration.liquibase.annotations.DBEntity;
import io.tesler.db.migration.liquibase.annotations.DBField;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.util.StringUtils;

public abstract class LqbAbstractEntity {
    public final List<Field> getDBRelatedFields() {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                DBField DBField2 = field.getAnnotation(DBField.class);
                if (DBField2 == null || StringUtils.isEmpty((String)DBField2.columnName())) continue;
                result.add(field);
            }
        }
        return result;
    }

    public String getFunctionValue(Field field) throws Exception {
        DBField DBField2 = field.getAnnotation(DBField.class);
        if (StringUtils.isEmpty((String)DBField2.functionField())) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(DBField2.functionField());
        return (String)propertyDescriptor.getReadMethod().invoke((Object)this, new Object[0]);
    }

    public String getSequenceValue(Field field) throws Exception {
        DBField DBField2 = field.getAnnotation(DBField.class);
        if (StringUtils.isEmpty((String)DBField2.sequenceField())) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(DBField2.sequenceField());
        return (String)propertyDescriptor.getReadMethod().invoke((Object)this, new Object[0]);
    }

    public String getFileValue(Field field) throws Exception {
        DBField DBField2 = field.getAnnotation(DBField.class);
        if (StringUtils.isEmpty((String)DBField2.fileField())) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(DBField2.fileField());
        return (String)propertyDescriptor.getReadMethod().invoke((Object)this, new Object[0]);
    }

    public String getTable() {
        DBEntity DBEntity2 = this.getClass().getAnnotation(DBEntity.class);
        if (DBEntity2 != null) {
            return DBEntity2.tableName();
        }
        return null;
    }

    public String getColumn(Field field) throws Exception {
        DBField DBField2 = field.getAnnotation(DBField.class);
        return DBField2.columnName();
    }

    public String getPrimaryKey() {
        DBEntity DBEntity2 = this.getClass().getAnnotation(DBEntity.class);
        if (DBEntity2 != null) {
            return DBEntity2.primaryKey();
        }
        return null;
    }

    public boolean insertNulls(Field field) throws Exception {
        DBField DBField2 = field.getAnnotation(DBField.class);
        return DBField2.insertNulls();
    }

    public Object getPKValue() throws Exception {
        String pkName = this.getPrimaryKey();
        if (pkName == null) {
            return null;
        }
        for (Field field : this.getDBRelatedFields()) {
            if (!pkName.equalsIgnoreCase(this.getColumn(field))) continue;
            return field.get(this);
        }
        return null;
    }

    protected BeanInfo getBeanInfo() throws Exception {
        return Introspector.getBeanInfo(this.getClass());
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) throws Exception {
        return Arrays.stream(this.getBeanInfo().getPropertyDescriptors()).filter(p -> name.equals(p.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException(name));
    }
}

