/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.LoadDataChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.ext.tesler.stmt.InsertPreparedStatement;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.BatchDmlExecutablePreparedStatement;
import liquibase.statement.ExecutablePreparedStatementBase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertSetStatement;

@DatabaseChange(name="loadData", description="Loads data from a CSV file into an existing table", priority=0x7FFFFFFF)
public class LoadDataChangeCustom
extends LoadDataChange {
    public SqlStatement[] generateStatements(Database database) {
        if (Boolean.TRUE.equals(this.getUsePreparedStatements())) {
            return super.generateStatements(database);
        }
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>();
        for (SqlStatement statement : super.generateStatements(database)) {
            result.addAll(this.simplify(statement));
        }
        return result.toArray(new SqlStatement[0]);
    }

    private List<SqlStatement> simplify(List<? extends SqlStatement> sqlStatements) {
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>(sqlStatements.size());
        for (SqlStatement sqlStatement : sqlStatements) {
            result.addAll(this.simplify(sqlStatement));
        }
        return result;
    }

    private List<SqlStatement> simplify(SqlStatement sqlStatement) {
        if (sqlStatement instanceof BatchDmlExecutablePreparedStatement) {
            return this.simplify(((BatchDmlExecutablePreparedStatement)sqlStatement).getIndividualStatements());
        }
        if (sqlStatement instanceof InsertSetStatement) {
            return this.simplify(((InsertSetStatement)sqlStatement).getStatements());
        }
        if (sqlStatement instanceof InsertPreparedStatement) {
            return Collections.singletonList(((InsertPreparedStatement)sqlStatement).simplify());
        }
        return Collections.singletonList(sqlStatement);
    }

    protected ExecutablePreparedStatementBase createPreparedStatement(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        return new InsertPreparedStatement(database, catalogName, schemaName, tableName, columns, changeSet, resourceAccessor);
    }
}

