/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.load;

import io.tesler.db.migration.liquibase.data.ViewEntity;
import io.tesler.db.migration.liquibase.data.ViewWidgetRelation;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.tesler.ui.load.AbstractEntityChange;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;

@DatabaseChange(name="viewload", description="Create view", priority=1)
public class ViewChange
extends AbstractEntityChange<ViewEntity> {
    @Override
    protected Class<ViewEntity> getElementType() {
        return ViewEntity.class;
    }

    @Override
    protected List<SqlStatement> generateStatements(Database database, ResourceAccessor resourceAccessor, ViewEntity entity) throws Exception {
        DeleteStatement delete = new DeleteStatement(null, null, "VIEW_WIDGETS");
        delete.setWhere("VIEW_NAME = ?");
        delete.addWhereParameter((Object)entity.getName());
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>();
        result.add((SqlStatement)delete);
        result.addAll(super.generateStatements(database, resourceAccessor, entity));
        AbstractEntityChange<ViewWidgetRelation> widgetChange = this.getEntityChange(database, resourceAccessor, ViewWidgetRelation.class);
        if (entity.getWidgets() != null) {
            for (ViewWidgetRelation widget : entity.getWidgets()) {
                widget.setViewName(entity.getName());
                result.addAll(widgetChange.generateStatements(database, resourceAccessor, widget));
            }
        }
        return result;
    }
}

