/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.core;

import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.ext.tesler.core.LoadDataChangeCustom;
import liquibase.ext.tesler.stmt.InsertTranslationStatement;
import liquibase.statement.core.InsertStatement;

@DatabaseChange(name="loadTranslationData", description="Loads translation data from a CSV file into an existing table", priority=0x7FFFFFFF)
public class LoadTranslationDataChange
extends LoadDataChangeCustom {
    private String mainTableName;
    private String surrogateKey;
    private String naturalKey;
    private String languageKey;

    @DatabaseChangeProperty(description="Main table name", requiredForDatabase={"all"})
    public String getMainTableName() {
        return this.mainTableName;
    }

    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    @DatabaseChangeProperty(description="Main table surrogate key", requiredForDatabase={"all"})
    public String getSurrogateKey() {
        return this.surrogateKey;
    }

    public void setSurrogateKey(String surrogateKey) {
        this.surrogateKey = surrogateKey;
    }

    @DatabaseChangeProperty(description="Comma delimited list of the columns for the natural key", requiredForDatabase={"all"})
    public String getNaturalKey() {
        return this.naturalKey;
    }

    public void setNaturalKey(String naturalKey) {
        this.naturalKey = naturalKey;
    }

    @DatabaseChangeProperty(description="Language column", requiredForDatabase={"all"})
    public String getLanguageKey() {
        return this.languageKey;
    }

    public void setLanguageKey(String languageKey) {
        this.languageKey = languageKey;
    }

    protected boolean hasPreparedStatementsImplemented() {
        return false;
    }

    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return new InsertTranslationStatement(catalogName, schemaName, tableName, this.getMainTableName(), this.getSurrogateKey(), this.getNaturalKey(), this.getLanguageKey());
    }
}

