/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.unload;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tesler.db.migration.liquibase.data.NavigationGroup;
import io.tesler.db.migration.liquibase.data.NavigationView;
import io.tesler.db.migration.liquibase.data.ScreenEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.change.DatabaseChange;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.tesler.ui.unload.AbstractEntityUnload;

@DatabaseChange(name="screenunload", description="Unload screens", priority=1)
public class ScreenUnload
extends AbstractEntityUnload {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void unload(JdbcConnection connection) throws Exception {
        ObjectMapper mapper = this.createMapper();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM SCREEN");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                FileOutputStream fos;
                block34: {
                    ScreenEntity screenEntity = new ScreenEntity();
                    screenEntity.setPrimaryViewName(resultSet.getString("PRIMARY_VIEW_NAME"));
                    screenEntity.setName(resultSet.getString("NAME"));
                    screenEntity.setTitle(resultSet.getString("TITLE"));
                    screenEntity.setPrimaryViews(this.asJson(mapper, resultSet, "PRIMARY_VIEWS"));
                    screenEntity.setNavigation(this.buildScreenNavigation(connection, resultSet.getString("NAME")));
                    File destination = this.buildDirectory("screens", screenEntity.getName());
                    fos = new FileOutputStream(new File(destination, String.format("%s.screen.json", screenEntity.getName())));
                    Throwable throwable = null;
                    try {
                        mapper.writeValue((OutputStream)fos, (Object)screenEntity);
                        if (fos == null) continue;
                        if (throwable == null) break block34;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    private ScreenEntity.ScreenNavigation buildScreenNavigation(JdbcConnection connection, String screenName) throws Exception {
        HashMap<String, ScreenEntity.ScreenNavigation.MenuItem> map = new HashMap<String, ScreenEntity.ScreenNavigation.MenuItem>();
        List<NavigationGroup> groups = this.getGroups(connection, screenName);
        List<NavigationView> views = this.getViews(connection, screenName);
        ArrayList<ScreenEntity.ScreenNavigation.MenuItem> menus = new ArrayList<ScreenEntity.ScreenNavigation.MenuItem>();
        for (NavigationGroup group : groups) {
            ScreenEntity.ScreenNavigation.MenuItem groupMenuItem = this.computeIfAbsent(map, group);
            groupMenuItem.setDefaultView(groupMenuItem.getTitle());
            groupMenuItem.setCommentDevelop(group.getDescription());
            groupMenuItem.setTitle(group.getTitle());
            groupMenuItem.setDefaultView(group.getDefaultView());
            groupMenuItem.setHidden(Integer.valueOf(1).equals(group.getHidden()));
            if (group.getParentId() == null) {
                menus.add(group.getSeq() > menus.size() ? menus.size() : group.getSeq().intValue(), groupMenuItem);
                continue;
            }
            NavigationGroup parentGroup = this.findParentGroup(groups, group);
            ScreenEntity.ScreenNavigation.MenuItem parentMenu = this.computeIfAbsent(map, parentGroup);
            if (parentMenu.getChild() == null) {
                parentMenu.setChild(new ArrayList<ScreenEntity.ScreenNavigation.MenuItem>());
            }
            List<ScreenEntity.ScreenNavigation.MenuItem> child = parentMenu.getChild();
            child.add(group.getSeq() > child.size() ? child.size() : group.getSeq().intValue(), groupMenuItem);
        }
        for (NavigationView view : views) {
            ScreenEntity.ScreenNavigation.MenuItem viewMenuItem = new ScreenEntity.ScreenNavigation.MenuItem();
            viewMenuItem.setViewName(view.getViewName());
            viewMenuItem.setCommentDevelop(view.getDescription());
            viewMenuItem.setHidden(Integer.valueOf(1).equals(view.getHidden()));
            if (view.getParentGroupId() == null) {
                menus.add(view.getSeq() > menus.size() ? menus.size() : view.getSeq().intValue(), viewMenuItem);
                continue;
            }
            ScreenEntity.ScreenNavigation.MenuItem parentMenu = (ScreenEntity.ScreenNavigation.MenuItem)map.get(view.getParentGroupId());
            if (parentMenu.getChild() == null) {
                parentMenu.setChild(new ArrayList<ScreenEntity.ScreenNavigation.MenuItem>());
            }
            List<ScreenEntity.ScreenNavigation.MenuItem> child = parentMenu.getChild();
            child.add(view.getSeq() > child.size() ? child.size() : view.getSeq().intValue(), viewMenuItem);
        }
        ScreenEntity.ScreenNavigation screenNavigation = new ScreenEntity.ScreenNavigation();
        screenNavigation.setMenu(menus);
        return screenNavigation;
    }

    private List<NavigationGroup> getGroups(JdbcConnection connection, String screenName) throws Exception {
        ArrayList<NavigationGroup> result = new ArrayList<NavigationGroup>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM NAVIGATION_GROUP WHERE (TYPE_CD != 'USER_GROUP' OR TYPE_CD IS NULL) AND SCREEN_NAME = ? ORDER BY SEQ ASC");){
            statement.setString(1, screenName);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    NavigationGroup entity = new NavigationGroup();
                    entity.setId(resultSet.getObject("ID", String.class));
                    entity.setTypeCd(resultSet.getString("TYPE_CD"));
                    entity.setScreenName(resultSet.getString("SCREEN_NAME"));
                    entity.setTitle(resultSet.getString("TITLE"));
                    entity.setParentId(resultSet.getObject("PARENT_ID", String.class));
                    entity.setSeq(resultSet.getObject("SEQ", Integer.class));
                    entity.setDescription(resultSet.getString("DESCRIPTION"));
                    entity.setHidden(resultSet.getInt("HIDDEN"));
                    result.add(entity);
                }
            }
        }
        return result;
    }

    private List<NavigationView> getViews(JdbcConnection connection, String screenName) throws Exception {
        ArrayList<NavigationView> result = new ArrayList<NavigationView>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM NAVIGATION_VIEW WHERE PARENT_GROUP_ID IN (SELECT NAVIGATION_GROUP.ID FROM NAVIGATION_GROUP WHERE (TYPE_CD != 'USER_GROUP' OR TYPE_CD IS NULL) AND SCREEN_NAME = ?) ORDER BY SEQ ASC");){
            statement.setString(1, screenName);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    NavigationView entity = new NavigationView();
                    entity.setId(resultSet.getObject("ID", String.class));
                    entity.setScreenName(resultSet.getString("SCREEN_NAME"));
                    entity.setViewName(resultSet.getString("VIEW_NAME"));
                    entity.setParentGroupId(resultSet.getObject("PARENT_GROUP_ID", String.class));
                    entity.setSeq(resultSet.getObject("SEQ", Integer.class));
                    entity.setHidden(resultSet.getInt("HIDDEN"));
                    result.add(entity);
                }
            }
        }
        return result;
    }

    private NavigationGroup findParentGroup(List<NavigationGroup> groups, NavigationGroup currentGroup) {
        for (NavigationGroup group : groups) {
            if (!Objects.equals(currentGroup.getParentId(), group.getId())) continue;
            return group;
        }
        return null;
    }

    private ScreenEntity.ScreenNavigation.MenuItem computeIfAbsent(Map<String, ScreenEntity.ScreenNavigation.MenuItem> map, NavigationGroup group) {
        ScreenEntity.ScreenNavigation.MenuItem value = map.get(group.getId());
        if (value != null) {
            return value;
        }
        ScreenEntity.ScreenNavigation.MenuItem newValue = new ScreenEntity.ScreenNavigation.MenuItem();
        map.put(group.getId(), newValue);
        return newValue;
    }
}

