/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.load;

import io.tesler.db.migration.liquibase.data.NavigationGroup;
import io.tesler.db.migration.liquibase.data.NavigationView;
import io.tesler.db.migration.liquibase.data.ScreenEntity;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.tesler.ui.load.AbstractEntityChange;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="screenload", description="Create screen", priority=1)
public class ScreenChange
extends AbstractEntityChange<ScreenEntity> {
    @Override
    protected Class<ScreenEntity> getElementType() {
        return ScreenEntity.class;
    }

    @Override
    protected List<SqlStatement> generateStatements(Database database, ResourceAccessor resourceAccessor, ScreenEntity entity) throws Exception {
        List<SqlStatement> result = super.generateStatements(database, resourceAccessor, entity);
        result.addAll(this.generateNavigationStatements(database, resourceAccessor, entity.getName(), null, entity.getNavigation().getMenu()));
        return result;
    }

    private List<SqlStatement> generateNavigationStatements(Database database, ResourceAccessor resourceAccessor, String screenName, String parentGroupId, List<ScreenEntity.ScreenNavigation.MenuItem> menuItems) throws Exception {
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>();
        if (menuItems == null || menuItems.isEmpty()) {
            return result;
        }
        int seq = 0;
        for (ScreenEntity.ScreenNavigation.MenuItem menuItem : menuItems) {
            String id;
            ++seq;
            if (menuItem.getChild() != null) {
                String string = id = parentGroupId == null ? screenName + "/" + seq + "/" : parentGroupId + seq + "/";
                if (menuItem.getChild().size() < 2) {
                    throw new IllegalStateException("Navigation group with id " + id + " must have at least 2 child elements");
                }
                if (menuItem.getTitle() == null) {
                    throw new IllegalStateException("Navigation group with id " + id + " must have a title");
                }
                result.addAll(this.navigationGroupStatements(database, resourceAccessor, id, "NAVIGATION", screenName, menuItem.getTitle(), parentGroupId, seq, menuItem.getCommentDevelop(), menuItem.getDefaultView(), menuItem.isHidden()));
                result.addAll(this.generateNavigationStatements(database, resourceAccessor, screenName, id, menuItem.getChild()));
                continue;
            }
            if (menuItem.getViewName() != null) {
                id = parentGroupId == null ? screenName + "/" + menuItem.getViewName() : parentGroupId + menuItem.getViewName();
                result.addAll(this.navigationViewStatements(database, resourceAccessor, id, "NAVIGATION", menuItem.getViewName(), screenName, parentGroupId, menuItem.getCommentDevelop(), seq, menuItem.isHidden()));
                continue;
            }
            throw new IllegalStateException("Unrecognized navigation element on screen: " + screenName);
        }
        return result;
    }

    private List<SqlStatement> navigationGroupStatements(Database database, ResourceAccessor resourceAccessor, String id, String typeCd, String screenName, String title, String parentId, Integer seq, String description, String defaultView, Boolean hidden) throws Exception {
        AbstractEntityChange<NavigationGroup> entityChange = this.getEntityChange(database, resourceAccessor, NavigationGroup.class);
        NavigationGroup entity = new NavigationGroup();
        entity.setId(id);
        entity.setTypeCd(typeCd);
        entity.setScreenName(screenName);
        entity.setTitle(title);
        entity.setParentId(parentId);
        entity.setSeq(seq);
        entity.setDescription(description);
        entity.setDefaultView(defaultView);
        entity.setHidden(hidden != false ? 1 : 0);
        return entityChange.generateStatements(database, resourceAccessor, entity);
    }

    private List<SqlStatement> navigationViewStatements(Database database, ResourceAccessor resourceAccessor, String id, String typeCd, String viewName, String screenName, String parentGroupId, String description, Integer seq, Boolean hidden) throws Exception {
        AbstractEntityChange<NavigationView> entityChange = this.getEntityChange(database, resourceAccessor, NavigationView.class);
        NavigationView entity = new NavigationView();
        entity.setId(id);
        entity.setTypeCd(typeCd);
        entity.setViewName(viewName);
        entity.setScreenName(screenName);
        entity.setParentGroupId(parentGroupId);
        entity.setSeq(seq);
        entity.setDescription(description);
        entity.setHidden(hidden != false ? 1 : 0);
        return entityChange.generateStatements(database, resourceAccessor, entity);
    }
}

