/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.core;

import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.InsertDataChange;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.ext.tesler.stmt.InsertPreparedStatement;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;

@DatabaseChange(name="insert", description="Inserts data into an existing table", priority=0x7FFFFFFF)
public class InsertDataChangeCustom
extends InsertDataChange {
    public SqlStatement[] generateStatements(Database database) {
        boolean needsPreparedStatement = false;
        for (ColumnConfig column : this.getColumns()) {
            if (column.getValueBlobFile() != null) {
                needsPreparedStatement = true;
            }
            if (column.getValueClobFile() != null) {
                needsPreparedStatement = true;
            }
            if (needsPreparedStatement || !(database instanceof InformixDatabase) || column.getValue() == null) continue;
            try {
                Column snapshot = (Column)SnapshotGeneratorFactory.getInstance().createSnapshot((DatabaseObject)new Column(column), database);
                if (snapshot == null) continue;
                needsPreparedStatement = true;
            }
            catch (Exception snapshot) {}
        }
        if (needsPreparedStatement) {
            return new SqlStatement[]{new InsertPreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumns(), this.getChangeSet(), this.getResourceAccessor())};
        }
        InsertStatement statement = new InsertStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.getColumns()) {
            if (database.supportsAutoIncrement() && column.isAutoIncrement() != null && column.isAutoIncrement().booleanValue()) continue;
            statement.addColumnValue(column.getName(), column.getValueObject());
        }
        return new SqlStatement[]{statement};
    }
}

