/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.db.migration.liquibase.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import io.tesler.db.migration.liquibase.annotations.DBEntity;
import io.tesler.db.migration.liquibase.annotations.DBField;
import io.tesler.db.migration.liquibase.data.LqbBaseEntity;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@DBEntity(tableName="SCREEN", primaryKey="NAME")
public class ScreenEntity
extends LqbBaseEntity {
    @DBField(columnName="NAME", insertNulls=true)
    private String name;
    @DBField(columnName="TITLE", insertNulls=true)
    private String title;
    @DBField(columnName="PRIMARY_VIEW_NAME", insertNulls=true)
    private String primaryViewName;
    @DBField(columnName="PRIMARY_VIEWS")
    private JsonNode primaryViews;
    private ScreenNavigation navigation;

    @Override
    public String getIdSequence() {
        String sequence = super.getIdSequence();
        if (StringUtils.isBlank((CharSequence)sequence)) {
            sequence = "APP_SEQ";
        }
        return sequence;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPrimaryViewName() {
        return this.primaryViewName;
    }

    public JsonNode getPrimaryViews() {
        return this.primaryViews;
    }

    public ScreenNavigation getNavigation() {
        return this.navigation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPrimaryViewName(String primaryViewName) {
        this.primaryViewName = primaryViewName;
    }

    public void setPrimaryViews(JsonNode primaryViews) {
        this.primaryViews = primaryViews;
    }

    public void setNavigation(ScreenNavigation navigation) {
        this.navigation = navigation;
    }

    public static class ScreenNavigation {
        private List<MenuItem> menu;

        public List<MenuItem> getMenu() {
            return this.menu;
        }

        public void setMenu(List<MenuItem> menu) {
            this.menu = menu;
        }

        @JsonPropertyOrder(value={"CommentDevelop"})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class MenuItem {
            private String commentDevelop;
            private boolean hidden;
            private String title;
            private String defaultView;
            private List<MenuItem> child;
            private String viewName;

            public String getCommentDevelop() {
                return this.commentDevelop;
            }

            public boolean isHidden() {
                return this.hidden;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDefaultView() {
                return this.defaultView;
            }

            public List<MenuItem> getChild() {
                return this.child;
            }

            public String getViewName() {
                return this.viewName;
            }

            public void setCommentDevelop(String commentDevelop) {
                this.commentDevelop = commentDevelop;
            }

            public void setHidden(boolean hidden) {
                this.hidden = hidden;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public void setDefaultView(String defaultView) {
                this.defaultView = defaultView;
            }

            public void setChild(List<MenuItem> child) {
                this.child = child;
            }

            public void setViewName(String viewName) {
                this.viewName = viewName;
            }
        }
    }
}

