/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.unload;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tesler.db.migration.liquibase.data.ViewEntity;
import io.tesler.db.migration.liquibase.data.ViewWidgetRelation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.DatabaseChange;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.tesler.ui.unload.AbstractEntityUnload;
import org.apache.commons.lang3.StringUtils;

@DatabaseChange(name="viewunload", description="Unload views", priority=1)
public class ViewUnload
extends AbstractEntityUnload {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void unload(JdbcConnection connection) throws Exception {
        ObjectMapper mapper = this.createMapper();
        PreparedStatement statement = connection.prepareStatement("SELECT * FROM VIEWS");
        try (ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                FileOutputStream fos;
                block25: {
                    List<ViewWidgetRelation> widgets;
                    BigDecimal customizable;
                    ViewEntity viewEntity = new ViewEntity();
                    viewEntity.setName(resultSet.getString("NAME"));
                    viewEntity.setTitle(resultSet.getString("TITLE"));
                    viewEntity.setTemplate(resultSet.getString("TEMPLATE"));
                    viewEntity.setUrl(resultSet.getString("URL"));
                    viewEntity.setOptions(this.asJson(mapper, resultSet, "OPTIONS"));
                    BigDecimal editable = resultSet.getBigDecimal("EDITABLE");
                    if (editable != null && editable.compareTo(new BigDecimal(0)) != 0) {
                        viewEntity.setEditable(editable.longValue());
                    }
                    if ((customizable = resultSet.getBigDecimal("CUSTOMIZABLE")) != null && customizable.compareTo(new BigDecimal(0)) != 0) {
                        viewEntity.setCustomizable(customizable.longValue());
                    }
                    if ((widgets = this.getWidgets(connection, viewEntity)) != null && !widgets.isEmpty()) {
                        viewEntity.setWidgets(widgets);
                    }
                    String screen = viewEntity.getUrl().split("/")[2];
                    File destination = this.buildDirectory("screens", screen, "views");
                    fos = new FileOutputStream(new File(destination, String.format("%s.view.json", viewEntity.getName())));
                    Throwable throwable = null;
                    try {
                        mapper.writeValue((OutputStream)fos, (Object)viewEntity);
                        if (fos == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    private List<ViewWidgetRelation> getWidgets(JdbcConnection connection, ViewEntity viewEntity) throws Exception {
        ArrayList<ViewWidgetRelation> result = new ArrayList<ViewWidgetRelation>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT VW.*, W.NAME AS WIDGET_NAME FROM VIEW_WIDGETS VW, WIDGET W WHERE W.ID=VW.WIDGET_ID AND VIEW_NAME = ? ORDER BY VW.POSITON");){
            statement.setString(1, viewEntity.getName());
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    Throwable throwable;
                    FileOutputStream fos;
                    File f;
                    BigDecimal pageLimit;
                    BigDecimal showExportStamp;
                    BigDecimal hideByDefault;
                    ViewWidgetRelation widget = new ViewWidgetRelation();
                    widget.setWidgetName(resultSet.getString("WIDGET_NAME"));
                    if (StringUtils.isBlank((CharSequence)widget.getWidgetName())) {
                        widget.setWidgetId(resultSet.getLong("WIDGET_ID"));
                    }
                    widget.setGridWidth(resultSet.getLong("GRID_WIDTH"));
                    widget.setPosition(resultSet.getLong("POSITON"));
                    widget.setDescriptionTitle(resultSet.getString("DESCRIPTION_TITLE"));
                    String description = resultSet.getString("DESCRIPTION");
                    String snippet = resultSet.getString("SNIPPET");
                    BigDecimal gridBreak = resultSet.getBigDecimal("GRID_BREAK");
                    if (gridBreak != null && gridBreak.compareTo(new BigDecimal(0)) != 0) {
                        widget.setGridBreak(gridBreak.longValue());
                    }
                    if ((hideByDefault = resultSet.getBigDecimal("HIDE_BY_DEFAULT")) != null && hideByDefault.compareTo(new BigDecimal(0)) != 0) {
                        widget.setHideByDefault(hideByDefault.longValue());
                    }
                    if ((showExportStamp = resultSet.getBigDecimal("SHOW_EXPORT_STAMP")) != null && showExportStamp.compareTo(new BigDecimal(0)) != 0) {
                        widget.setShowExportStamp(showExportStamp.longValue());
                    }
                    if ((pageLimit = resultSet.getBigDecimal("PAGE_LIMIT")) != null) {
                        widget.setPageLimit(pageLimit.longValue());
                    }
                    String screen = viewEntity.getUrl().split("/")[2];
                    File destination = this.buildDirectory("screens", screen, "views");
                    String prefix = StringUtils.isNotBlank((CharSequence)widget.getWidgetName()) ? widget.getWidgetName() : String.format("%06d", widget.getId());
                    if (description != null) {
                        f = new File(destination, "descriptions");
                        f.mkdirs();
                        fos = new FileOutputStream(new File(f, String.format("%s-%s.description.txt", viewEntity.getName(), prefix)));
                        throwable = null;
                        try {
                            fos.write(description.getBytes());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fos != null) {
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    fos.close();
                                }
                            }
                        }
                        widget.setDescriptionFile(String.format("%s/screens/%s/views/descriptions/%s-%s.description.txt", "db/migration/liquidbase/data/latest", screen, viewEntity.getName(), prefix));
                    }
                    if (snippet != null) {
                        f = new File(destination, "snippets");
                        f.mkdirs();
                        fos = new FileOutputStream(new File(f, String.format("%s-%s.snippet.txt", viewEntity.getName(), prefix)));
                        throwable = null;
                        try {
                            fos.write(snippet.getBytes());
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (fos != null) {
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    fos.close();
                                }
                            }
                        }
                        widget.setSnippetFile(String.format("%s/screens/%s/views/snippets/%s-%s.snippet.txt", "db/migration/liquidbase/data/latest", screen, viewEntity.getName(), prefix));
                    }
                    result.add(widget);
                }
            }
        }
        return result;
    }
}

