/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.unload;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tesler.db.migration.liquibase.data.ScreenEntity;
import io.tesler.db.migration.liquibase.data.ScreenViewGroup;
import io.tesler.db.migration.liquibase.data.ScreenViewGroupData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.change.DatabaseChange;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.tesler.ui.unload.AbstractEntityUnload;

@DatabaseChange(name="screenunload", description="Unload screens", priority=1)
public class ScreenUnload
extends AbstractEntityUnload {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void unload(JdbcConnection connection) throws Exception {
        ObjectMapper mapper = this.createMapper();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM SCREEN");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                FileOutputStream fos;
                block34: {
                    ScreenEntity screenEntity = new ScreenEntity();
                    screenEntity.setPrimaryViewName(resultSet.getString("PRIMARY_VIEW_NAME"));
                    screenEntity.setName(resultSet.getString("NAME"));
                    screenEntity.setTitle(resultSet.getString("TITLE"));
                    screenEntity.setPrimaryViews(this.asJson(mapper, resultSet, "PRIMARY_VIEWS"));
                    screenEntity.setNavigation(this.buildScreenNavigation(connection, resultSet.getString("NAME")));
                    File destination = this.buildDirectory("screens", screenEntity.getName());
                    fos = new FileOutputStream(new File(destination, String.format("%s.screen.json", screenEntity.getName())));
                    Throwable throwable = null;
                    try {
                        mapper.writeValue((OutputStream)fos, (Object)screenEntity);
                        if (fos == null) continue;
                        if (throwable == null) break block34;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    private ScreenEntity.ScreenNavigation buildScreenNavigation(JdbcConnection connection, String screenName) throws Exception {
        ScreenEntity.ScreenNavigation.Menu menu;
        HashMap<Long, ScreenEntity.ScreenNavigation.Menu> map = new HashMap<Long, ScreenEntity.ScreenNavigation.Menu>();
        List<ScreenViewGroup> groups = this.getGroups(connection, screenName);
        List<ScreenViewGroupData> views = this.getViews(connection, screenName);
        ArrayList<ScreenEntity.ScreenNavigation.Menu> menus = new ArrayList<ScreenEntity.ScreenNavigation.Menu>();
        for (ScreenViewGroup group : groups) {
            menu = this.computeIfAbsent(map, group);
            menu.setId(group.getId());
            menu.setCommentDevelop(group.getDescription());
            if (Objects.equals(group.getRoot(), 1)) {
                menu.setTitle(group.getTitle());
            } else {
                menu.setCategoryName(group.getTitle());
            }
            if (group.getParentId() == null) {
                menus.add(group.getSeq() > menus.size() ? menus.size() : group.getSeq().intValue(), menu);
                continue;
            }
            if (!(menu instanceof ScreenEntity.ScreenNavigation.SubMenu)) continue;
            ScreenViewGroup parentGroup = this.findParentGroup(groups, group);
            ScreenEntity.ScreenNavigation.Menu parentMenu = this.computeIfAbsent(map, parentGroup);
            if (parentMenu.getChild() == null) {
                parentMenu.setChild(new ArrayList<ScreenEntity.ScreenNavigation.SubMenu>());
            }
            List<ScreenEntity.ScreenNavigation.SubMenu> child = parentMenu.getChild();
            child.add(group.getSeq() > child.size() ? child.size() : group.getSeq().intValue(), (ScreenEntity.ScreenNavigation.SubMenu)menu);
        }
        for (ScreenViewGroupData view : views) {
            menu = new ScreenEntity.ScreenNavigation.SubMenu();
            ((ScreenEntity.ScreenNavigation.SubMenu)menu).setViewName(view.getViewName());
            ScreenEntity.ScreenNavigation.Menu parentMenu = (ScreenEntity.ScreenNavigation.Menu)map.get(view.getViewGroupId());
            if (parentMenu.getChild() == null) {
                parentMenu.setChild(new ArrayList<ScreenEntity.ScreenNavigation.SubMenu>());
            }
            List<ScreenEntity.ScreenNavigation.SubMenu> child = parentMenu.getChild();
            child.add(view.getSeq() > child.size() ? child.size() : view.getSeq().intValue(), (ScreenEntity.ScreenNavigation.SubMenu)menu);
        }
        ScreenEntity.ScreenNavigation screenNavigation = new ScreenEntity.ScreenNavigation();
        screenNavigation.setMenu(menus);
        return screenNavigation;
    }

    private List<ScreenViewGroup> getGroups(JdbcConnection connection, String screenName) throws Exception {
        ArrayList<ScreenViewGroup> result = new ArrayList<ScreenViewGroup>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM SCREEN_VIEW_GROUP WHERE (TYPE_CD != 'USER_GROUP' OR TYPE_CD IS NULL) AND SCREEN_NAME = ? ORDER BY SEQ ASC");){
            statement.setString(1, screenName);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    ScreenViewGroup entity = new ScreenViewGroup();
                    entity.setId(resultSet.getObject("ID", Long.class));
                    entity.setTypeCd(resultSet.getString("TYPE_CD"));
                    entity.setScreenName(resultSet.getString("SCREEN_NAME"));
                    entity.setTitle(resultSet.getString("TITLE"));
                    entity.setParentId(resultSet.getObject("PARENT_ID", Long.class));
                    entity.setSeq(resultSet.getObject("SEQ", Integer.class));
                    entity.setDescription(resultSet.getString("DESCRIPTION"));
                    entity.setRoot(resultSet.getInt("ROOT"));
                    result.add(entity);
                }
            }
        }
        return result;
    }

    private List<ScreenViewGroupData> getViews(JdbcConnection connection, String screenName) throws Exception {
        ArrayList<ScreenViewGroupData> result = new ArrayList<ScreenViewGroupData>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM SCREEN_VIEW_GROUP_DATA WHERE VIEW_GROUP_ID IN (SELECT SCREEN_VIEW_GROUP.ID FROM SCREEN_VIEW_GROUP WHERE (TYPE_CD != 'USER_GROUP' OR TYPE_CD IS NULL) AND SCREEN_NAME = ?) ORDER BY SEQ ASC");){
            statement.setString(1, screenName);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    ScreenViewGroupData entity = new ScreenViewGroupData();
                    entity.setId(resultSet.getObject("ID", Long.class));
                    entity.setViewName(resultSet.getString("VIEW_NAME"));
                    entity.setViewGroupId(resultSet.getObject("VIEW_GROUP_ID", Long.class));
                    entity.setSeq(resultSet.getObject("SEQ", Integer.class));
                    result.add(entity);
                }
            }
        }
        return result;
    }

    private ScreenViewGroup findParentGroup(List<ScreenViewGroup> groups, ScreenViewGroup currentGroup) {
        for (ScreenViewGroup group : groups) {
            if (!Objects.equals(currentGroup.getParentId(), group.getId())) continue;
            return group;
        }
        return null;
    }

    private ScreenEntity.ScreenNavigation.Menu computeIfAbsent(Map<Long, ScreenEntity.ScreenNavigation.Menu> map, ScreenViewGroup group) {
        ScreenEntity.ScreenNavigation.Menu value = map.get(group.getId());
        if (value != null) {
            return value;
        }
        ScreenEntity.ScreenNavigation.Menu newValue = group.getParentId() == null ? new ScreenEntity.ScreenNavigation.Menu() : new ScreenEntity.ScreenNavigation.SubMenu();
        map.put(group.getId(), newValue);
        return newValue;
    }
}

