/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.ext.tesler.stmt.InsertTranslationStatement;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertStatement;

public class InsertTranslationGenerator
extends AbstractSqlGenerator<InsertTranslationStatement> {
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public ValidationErrors validate(InsertTranslationStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("mainTableName", (Object)statement.getMainTableName());
        validationErrors.checkRequiredField("mainTablePrimaryKey", (Object)statement.getSurrogateKey());
        validationErrors.checkRequiredField("languageColumn", (Object)statement.getLanguageKey());
        validationErrors.checkRequiredField("primaryKey", statement.getNaturalKey());
        validationErrors.checkRequiredField("columns", (Object)statement.getColumnValues());
        return validationErrors;
    }

    public Sql[] generateSql(InsertTranslationStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, this.generateDeleteStatement(statement, database));
        Collections.addAll(result, this.generateInsertStatement(statement, database));
        return result.toArray(new Sql[0]);
    }

    protected Sql[] generateInsertStatement(InsertTranslationStatement statement, Database database) {
        InsertStatement insertStatement = new InsertStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        insertStatement.addColumnValue(statement.getSurrogateKey(), (Object)new DatabaseFunction(this.getSelectPrimaryKeyStatement(statement, database)));
        for (Map.Entry e : statement.getColumnValues().entrySet()) {
            String columnName = (String)e.getKey();
            if (statement.getNaturalKey().contains(columnName)) continue;
            insertStatement.addColumnValue(columnName, e.getValue());
        }
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)insertStatement, database);
    }

    protected Sql[] generateDeleteStatement(InsertTranslationStatement statement, Database database) {
        DeleteStatement deleteStatement = new DeleteStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append(this.toColumnPredicate(statement, database, statement.getLanguageKey(), statement.getColumnValue(statement.getLanguageKey())));
        whereBuilder.append(" AND ");
        whereBuilder.append(this.toColumnPredicate(statement, database, statement.getSurrogateKey(), new DatabaseFunction(this.getSelectPrimaryKeyStatement(statement, database))));
        deleteStatement.setWhere(whereBuilder.toString());
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)deleteStatement, database);
    }

    public String getSelectPrimaryKeyStatement(InsertTranslationStatement statement, Database database) {
        StringBuilder subqeury = new StringBuilder("(SELECT ");
        subqeury.append(this.toDatabaseColumn(statement, database, statement.getSurrogateKey()));
        subqeury.append(" FROM ");
        subqeury.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getMainTableName()));
        subqeury.append(" WHERE (");
        Iterator<String> iter = statement.getNaturalKey().iterator();
        while (iter.hasNext()) {
            String columnName = iter.next();
            subqeury.append(this.toColumnPredicate(statement, database, columnName, statement.getColumnValue(columnName)));
            if (!iter.hasNext()) continue;
            subqeury.append(" AND ");
        }
        subqeury.append("))");
        return subqeury.toString();
    }

    protected String toColumnPredicate(InsertTranslationStatement statement, Database database, String columnName, Object value) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toDatabaseColumn(statement, database, columnName));
        if (this.isNull(value)) {
            builder.append(" IS ");
        } else {
            builder.append(" = ");
        }
        builder.append(this.toDatabaseString(value, database));
        return builder.toString();
    }

    protected String toDatabaseColumn(InsertTranslationStatement statement, Database database, String columnName) {
        return database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), columnName);
    }

    protected String toDatabaseString(Object value, Database database) {
        if (this.isNull(value)) {
            return "NULL";
        }
        return DataTypeFactory.getInstance().fromObject(value, database).objectToSql(value, database);
    }

    protected boolean isNull(Object value) {
        return value == null || "NULL".equalsIgnoreCase(value.toString());
    }
}

