/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.load;

import io.tesler.db.migration.liquibase.data.WidgetEntity;
import io.tesler.db.migration.liquibase.data.WidgetProperty;
import java.util.List;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.tesler.ui.load.AbstractEntityChange;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import org.apache.commons.lang3.BooleanUtils;

@DatabaseChange(name="widgetload", description="Create widget", priority=1)
public class WidgetChange
extends AbstractEntityChange<WidgetEntity> {
    @Override
    protected Class<WidgetEntity> getElementType() {
        return WidgetEntity.class;
    }

    @Override
    protected List<SqlStatement> generateStatements(Database database, ResourceAccessor resourceAccessor, WidgetEntity entity) throws Exception {
        List<SqlStatement> resultStatements = super.generateStatements(database, resourceAccessor, entity);
        AbstractEntityChange<WidgetProperty> widgetChange = this.getEntityChange(database, resourceAccessor, WidgetProperty.class);
        WidgetProperty widgetProperty = new WidgetProperty();
        widgetProperty.setConclusionType(BooleanUtils.toBooleanDefaultIfNull((Boolean)entity.getIsConclusionWidget(), (boolean)false));
        widgetProperty.setWidgetId(entity.getId());
        widgetProperty.setWidgetName(entity.getName());
        resultStatements.addAll(widgetChange.generateStatements(database, resourceAccessor, widgetProperty));
        return resultStatements;
    }
}

