/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.load;

import io.tesler.db.migration.liquibase.data.ScreenEntity;
import io.tesler.db.migration.liquibase.data.ScreenViewGroup;
import io.tesler.db.migration.liquibase.data.ScreenViewGroupData;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.tesler.ui.load.AbstractEntityChange;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="screenload", description="Create screen", priority=1)
public class ScreenChange
extends AbstractEntityChange<ScreenEntity> {
    @Override
    protected Class<ScreenEntity> getElementType() {
        return ScreenEntity.class;
    }

    @Override
    protected List<SqlStatement> generateStatements(Database database, ResourceAccessor resourceAccessor, ScreenEntity entity) throws Exception {
        List<SqlStatement> result = super.generateStatements(database, resourceAccessor, entity);
        result.addAll(this.generateGroupStatements(database, resourceAccessor, entity.getName(), entity.getNavigation()));
        return result;
    }

    private List<SqlStatement> generateGroupStatements(Database database, ResourceAccessor resourceAccessor, String screenName, ScreenEntity.ScreenNavigation navigation) throws Exception {
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>();
        List<ScreenEntity.ScreenNavigation.Menu> menus = navigation.getMenu();
        for (int i = 0; i < menus.size(); ++i) {
            ScreenEntity.ScreenNavigation.Menu menu = menus.get(i);
            result.addAll(this.viewGroupStatements(database, resourceAccessor, menu.getId(), "NAVIGATION", screenName, menu.getTitle(), menu.getCategoryName(), null, menu.getCommentDevelop(), i + 1));
            result.addAll(this.groupAndDataStatements(database, resourceAccessor, screenName, menu.getId(), menu.getChild()));
        }
        return result;
    }

    private List<SqlStatement> groupAndDataStatements(Database database, ResourceAccessor resourceAccessor, String screenName, Long parentGroupId, List<ScreenEntity.ScreenNavigation.SubMenu> subMenus) throws Exception {
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>();
        if (subMenus == null || subMenus.isEmpty()) {
            return result;
        }
        int seq = 0;
        for (ScreenEntity.ScreenNavigation.SubMenu subMenu : subMenus) {
            if (subMenu.getViewName() == null) {
                result.addAll(this.viewGroupStatements(database, resourceAccessor, subMenu.getId(), "NAVIGATION", screenName, null, subMenu.getCategoryName(), parentGroupId, subMenu.getCommentDevelop(), seq++));
                result.addAll(this.groupAndDataStatements(database, resourceAccessor, screenName, subMenu.getId(), subMenu.getChild()));
                continue;
            }
            result.addAll(this.viewGroupDataStatements(database, resourceAccessor, subMenu.getViewName(), parentGroupId, seq++));
        }
        return result;
    }

    private List<SqlStatement> viewGroupStatements(Database database, ResourceAccessor resourceAccessor, Long id, String typeCd, String screenName, String title, String categoryName, Long parentId, String comment, Integer seq) throws Exception {
        AbstractEntityChange<ScreenViewGroup> entityChange = this.getEntityChange(database, resourceAccessor, ScreenViewGroup.class);
        ScreenViewGroup entity = new ScreenViewGroup();
        entity.setId(id);
        entity.setTypeCd(typeCd);
        entity.setScreenName(screenName);
        entity.setTitle(title == null ? categoryName : title);
        entity.setParentId(parentId);
        entity.setSeq(seq);
        entity.setDescription(comment);
        entity.setRoot(title == null ? 0 : 1);
        return entityChange.generateStatements(database, resourceAccessor, entity);
    }

    private List<SqlStatement> viewGroupDataStatements(Database database, ResourceAccessor resourceAccessor, String viewName, Long viewGroupId, Integer seq) throws Exception {
        AbstractEntityChange<ScreenViewGroupData> entityChange = this.getEntityChange(database, resourceAccessor, ScreenViewGroupData.class);
        ScreenViewGroupData entity = new ScreenViewGroupData();
        entity.setIdSequence("APP_SEQ");
        entity.setViewName(viewName);
        entity.setViewGroupId(viewGroupId);
        entity.setSeq(seq);
        return entityChange.generateStatements(database, resourceAccessor, entity);
    }
}

