/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.tesler.ui.load;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.TextNode;
import io.tesler.db.migration.liquibase.data.AbstractEntity;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.tesler.stmt.InsertPreparedStatement;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityChange<T extends AbstractEntity>
extends AbstractChange {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityChange.class);
    public static final int MAX_CHARS = 2000;
    public static final ChangeSet EMPTY_CHANGE_SET = new ChangeSet(new DatabaseChangeLog(null));
    private String file;
    private String path;
    private String filter;
    private String encoding;
    private Boolean recursive;
    private List<T> elements = new ArrayList<T>();

    private static Reader createReader(InputStream in, String encoding) {
        if (StringUtils.trimToNull((String)encoding) == null) {
            return new BufferedReader((Reader)new UtfBomAwareReader(in));
        }
        return new BufferedReader((Reader)new UtfBomAwareReader(in, encoding));
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @DatabaseChangeProperty(description="JSON file to load", exampleValue="com/example/widget.json")
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @DatabaseChangeProperty(description="Encoding of the JSON file (defaults to UTF-8)", exampleValue="UTF-8")
    public String getEncoding() {
        if (this.encoding == null) {
            return "UTF-8";
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPath() {
        return this.path;
    }

    @DatabaseChangeProperty(description="Directory containing JSON files")
    public void setPath(String path) {
        this.path = path;
    }

    @DatabaseChangeProperty(description="Regexp to filter directory content")
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @DatabaseChangeProperty(description="Whether to search JSON files recursively")
    public Boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive == null ? Boolean.valueOf(false) : recursive;
    }

    public String getConfirmationMessage() {
        StringBuilder message = new StringBuilder("Data loaded from ");
        if (this.getFile() != null) {
            message.append(this.getFile());
        } else {
            message.append(this.getPath());
        }
        if (this.isRecursive().booleanValue()) {
            message.append(" recursively");
        }
        if (this.getFilter() != null) {
            message.append(", filter: ").append(this.getFilter());
        }
        return message.toString();
    }

    public Set<String> getSerializableFields() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(super.getSerializableFields());
        result.add("elements");
        return result;
    }

    public Object getSerializableFieldValue(String field) {
        try {
            if ("elements".equals(field)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
                mapper.writeValue((OutputStream)baos, this.elements);
                return new String(baos.toByteArray(), StandardCharsets.UTF_8);
            }
            return super.getSerializableFieldValue(field);
        }
        catch (Exception ex) {
            throw new UnexpectedLiquibaseException((Throwable)ex);
        }
    }

    protected List<SqlStatement> generateStatements(Database database, ResourceAccessor resourceAccessor, T entity) throws Exception {
        boolean isPrepared = false;
        ArrayList<SqlStatement> result = new ArrayList<SqlStatement>();
        ArrayList<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>();
        for (Field field : ((AbstractEntity)entity).getDBRelatedFields()) {
            ColumnConfig columnConfig = this.toColumnConfig(field, entity, resourceAccessor);
            if (columnConfig == null) continue;
            isPrepared |= columnConfig.getValueClobFile() != null;
            isPrepared |= columnConfig.getValueBlobFile() != null;
            columnConfigs.add(columnConfig);
        }
        if (isPrepared) {
            result.add((SqlStatement)new InsertPreparedStatement(database, ((AbstractEntity)entity).getTable(), columnConfigs, EMPTY_CHANGE_SET, resourceAccessor));
            return result;
        }
        String primaryKey = ((AbstractEntity)entity).getPrimaryKey();
        Object pkValue = ((AbstractEntity)entity).getPKValue();
        Object statement = StringUtils.isEmpty((String)primaryKey) || pkValue == null ? new InsertStatement(null, null, ((AbstractEntity)entity).getTable()) : new InsertOrUpdateStatement(null, null, ((AbstractEntity)entity).getTable(), primaryKey);
        for (ColumnConfig columnConfig : columnConfigs) {
            statement.addColumn(columnConfig);
        }
        result.add((SqlStatement)statement);
        return result;
    }

    public ColumnConfig toColumnConfig(Field field, T entity, ResourceAccessor resourceAccessor) throws Exception {
        Object value = field.get(entity);
        if (value != null) {
            return this.getColumnConfig(((AbstractEntity)entity).getColumn(field), value);
        }
        ColumnConfig columnConfig = this.getComputedColumnConfig(field, entity);
        if (columnConfig != null) {
            return columnConfig;
        }
        columnConfig = this.getSequenceColumnConfig(field, entity);
        if (columnConfig != null) {
            return columnConfig;
        }
        columnConfig = this.getFileColumnConfig(field, entity, resourceAccessor);
        if (columnConfig != null) {
            return columnConfig;
        }
        if (((AbstractEntity)entity).insertNulls(field)) {
            return this.getStringColumnConfig(((AbstractEntity)entity).getColumn(field), null);
        }
        return null;
    }

    protected ColumnConfig getFileColumnConfig(Field field, T entity, ResourceAccessor resourceAccessor) throws Exception {
        String file = ((AbstractEntity)entity).getFileValue(field);
        if (StringUtils.isEmpty((String)file)) {
            return null;
        }
        boolean isText = CharSequence.class.isAssignableFrom(field.getType());
        if (isText |= JsonSerializable.class.isAssignableFrom(field.getType())) {
            try (Reader reader = this.getReader(file, resourceAccessor);){
                StringBuilder value = new StringBuilder();
                int i = -1;
                while ((i = reader.read()) != -1) {
                    value.append((char)i);
                }
                ColumnConfig columnConfig = this.getStringColumnConfig(((AbstractEntity)entity).getColumn(field), value.toString());
                return columnConfig;
            }
        }
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(((AbstractEntity)entity).getColumn(field));
        columnConfig.setValueBlobFile(file);
        return columnConfig;
    }

    protected ColumnConfig getComputedColumnConfig(Field field, T entity) throws Exception {
        String function = ((AbstractEntity)entity).getFunctionValue(field);
        if (StringUtils.isEmpty((String)function)) {
            return null;
        }
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(((AbstractEntity)entity).getColumn(field), true);
        return columnConfig.setValueComputed(new DatabaseFunction(function));
    }

    protected ColumnConfig getSequenceColumnConfig(Field field, T entity) throws Exception {
        String sequence = ((AbstractEntity)entity).getSequenceValue(field);
        if (StringUtils.isEmpty((String)sequence)) {
            return null;
        }
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(((AbstractEntity)entity).getColumn(field), true);
        return columnConfig.setValueSequenceNext(new SequenceNextValueFunction(sequence));
    }

    protected ColumnConfig getColumnConfig(String columnName, Object value) throws Exception {
        if (value == null) {
            return this.getStringColumnConfig(columnName, null);
        }
        if (value instanceof TextNode) {
            ObjectMapper mapper = new ObjectMapper();
            return this.getColumnConfig(columnName, mapper.readTree(((TextNode)value).asText()));
        }
        if (value instanceof JsonNode) {
            return this.getStringColumnConfig(columnName, value.toString());
        }
        if (value instanceof String) {
            return this.getStringColumnConfig(columnName, (String)value);
        }
        if (value instanceof Number) {
            return this.getNumberColumnConfig(columnName, (Number)value);
        }
        if (value instanceof Date) {
            return this.getDateColumnConfig(columnName, (Date)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? this.getNumberColumnConfig(columnName, 1) : this.getNumberColumnConfig(columnName, 0);
        }
        throw new IllegalArgumentException("Unsupported value type:" + value.getClass());
    }

    protected ColumnConfig getDateColumnConfig(String columnName, Date value) {
        ColumnConfig columnConfig = new ColumnConfig().setName(columnName);
        return columnConfig.setValueDate(value);
    }

    protected ColumnConfig getNumberColumnConfig(String columnName, Number value) {
        ColumnConfig columnConfig = new ColumnConfig().setName(columnName);
        return columnConfig.setValueNumeric(value);
    }

    protected ColumnConfig getStringColumnConfig(String columnName, String value) {
        ColumnConfig columnConfig = new ColumnConfig().setName(columnName);
        if (value == null || value.length() < 2000) {
            return columnConfig.setValue(value);
        }
        columnConfig.setComputed(Boolean.valueOf(true));
        StringBuilder expression = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i += 2000) {
            char[] part = Arrays.copyOfRange(chars, i, Math.min(chars.length, i + 2000));
            expression.append("TO_CLOB('").append(this.escapeString(new String(part))).append("')");
            if (i >= chars.length - 2000) continue;
            expression.append("||");
        }
        columnConfig.setValueComputed(new DatabaseFunction(expression.toString()));
        return columnConfig;
    }

    private String escapeString(String string) {
        return string.replace("'", "''");
    }

    protected void customLoadLogic(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        String lastFile = null;
        int lastPosition = 0;
        try {
            HashMap<Object, String> seenKeys = new HashMap<Object, String>();
            Iterator<String> iterator = this.getResources(resourceAccessor).iterator();
            while (iterator.hasNext()) {
                String file;
                lastFile = file = iterator.next();
                AbstractEntity[] elements = this.read(file, resourceAccessor);
                int n = elements.length;
                for (int i = 0; i < n; ++i) {
                    lastPosition = i;
                    AbstractEntity element = elements[i];
                    Object pkValue = element.getPKValue();
                    if (pkValue != null) {
                        if (seenKeys.containsKey(pkValue)) {
                            throw new SetupException("Failed to process file: " + lastFile + ", position: " + lastPosition + ", reason: duplicate has been found in file " + (String)seenKeys.get(pkValue));
                        }
                        seenKeys.put(pkValue, file);
                    }
                    this.elements.add(element);
                }
            }
        }
        catch (ParsedNodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ParsedNodeException("Failed to process file: " + lastFile + ", position: " + lastPosition + ", reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean supports(Database database) {
        return true;
    }

    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    public boolean generateRollbackStatementsVolatile(Database database) {
        return true;
    }

    public SqlStatement[] generateStatements(Database database) {
        try {
            ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
            for (AbstractEntity element : this.elements) {
                sqlStatements.addAll(this.generateStatements(database, this.getResourceAccessor(), element));
            }
            return sqlStatements.toArray(new SqlStatement[0]);
        }
        catch (Exception ex) {
            throw new UnexpectedLiquibaseException((Throwable)ex);
        }
    }

    private Class<T[]> getArrayClass() {
        return Array.newInstance(this.getElementType(), 0).getClass();
    }

    protected abstract Class<T> getElementType();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T[] read(String file, ResourceAccessor resourceAccessor) throws UnexpectedLiquibaseException {
        try (Reader reader = this.getReader(file, resourceAccessor);){
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            AbstractEntity[] abstractEntityArray = (AbstractEntity[])mapper.readValue(reader, this.getArrayClass());
            return abstractEntityArray;
        }
        catch (Exception ex) {
            throw new UnexpectedLiquibaseException("Failed to read " + file, (Throwable)ex);
        }
    }

    private Reader getReader(String file, ResourceAccessor resourceAccessor) throws IOException {
        if (resourceAccessor == null) {
            throw new UnexpectedLiquibaseException("No file resourceAccessor specified for " + file);
        }
        InputStream stream = StreamUtil.openStream((String)file, (Boolean)false, null, (ResourceAccessor)resourceAccessor);
        if (stream == null) {
            throw new UnexpectedLiquibaseException("Unable to read " + file);
        }
        return AbstractEntityChange.createReader(stream, this.getEncoding());
    }

    protected Set<String> getResources(ResourceAccessor resourceAccessor) throws IOException, ParsedNodeException {
        Set unsorted;
        if (this.getFile() != null) {
            return Collections.singleton(this.getFile());
        }
        String path = this.getPath();
        if (path == null) {
            throw new ParsedNodeException("You must specify either dir or path");
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + '/';
        }
        if (((unsorted = resourceAccessor.list(null, path, true, false, this.isRecursive().booleanValue())) == null || unsorted.isEmpty()) && this.isRecursive().booleanValue()) {
            unsorted = resourceAccessor.list(null, path + '*', true, false, this.isRecursive().booleanValue());
        }
        TreeSet<String> resources = new TreeSet<String>(this.getStandardComparator());
        if (unsorted != null) {
            for (String resourcePath : unsorted) {
                if (this.filter == null) {
                    resources.add(resourcePath);
                    continue;
                }
                if (!resourcePath.matches(this.filter)) continue;
                resources.add(resourcePath);
            }
        }
        if (resources.isEmpty()) {
            throw new ParsedNodeException("Could not find directory or directory was empty for path '" + this.getPath() + "'");
        }
        return resources;
    }

    protected Comparator<String> getStandardComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return this.normalize(o1).compareTo(this.normalize(o2));
            }

            private String normalize(String string) {
                if (string == null) {
                    return null;
                }
                return string.replace("WEB-INF/classes/", "");
            }
        };
    }

    <E extends AbstractEntity> AbstractEntityChange<E> getEntityChange(Database database, ResourceAccessor resourceAccessor, final Class<E> entityClass) {
        AbstractEntityChange viewChange = new AbstractEntityChange<E>(){

            @Override
            protected Class<E> getElementType() {
                return entityClass;
            }
        };
        viewChange.setChangeSet(this.getChangeSet());
        viewChange.setEncoding(this.getEncoding());
        viewChange.setResourceAccessor(resourceAccessor);
        return viewChange;
    }
}

