/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.db.migration.liquibase.spring;

import java.io.IOException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SpringLiquibase
extends liquibase.integration.spring.SpringLiquibase {
    private static final Logger log = LoggerFactory.getLogger(SpringLiquibase.class);
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";

    protected SpringLiquibase.SpringResourceOpener createResourceOpener() {
        return new SpringResourceOpenerCustom(this.getChangeLog());
    }

    public class SpringResourceOpenerCustom
    extends SpringLiquibase.SpringResourceOpener {
        public SpringResourceOpenerCustom(String parentFile) {
            super((liquibase.integration.spring.SpringLiquibase)SpringLiquibase.this, parentFile);
        }

        protected void init() {
            super.init();
            try {
                Resource[] resources;
                for (Resource res : resources = this.getResources(String.format("classpath*:/%s", SpringLiquibase.MANIFEST_MF))) {
                    this.addResource(res);
                }
            }
            catch (IOException e) {
                LogService.getLog(((Object)((Object)this)).getClass()).warning(LogType.LOG, "Error initializing SpringLiquibase", (Throwable)e);
            }
        }

        private void addResource(Resource resource) throws IOException {
            if (resource == null) {
                return;
            }
            String externalForm = resource.getURL().toExternalForm();
            externalForm = externalForm.replace(SpringLiquibase.MANIFEST_MF, "");
            this.addRootPath(externalForm);
        }

        private void addRootPath(String path) {
            if (!super.getRootPaths().contains(path)) {
                super.getRootPaths().add(path);
            }
        }

        private Resource[] getResources(String foundPackage) throws IOException {
            return ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources(foundPackage);
        }
    }
}

