/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.db.migration.liquibase.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import io.tesler.db.migration.liquibase.annotations.DBEntity;
import io.tesler.db.migration.liquibase.annotations.DBField;
import io.tesler.db.migration.liquibase.data.AbstractEntity;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@DBEntity(tableName="SCREEN", primaryKey="NAME")
public class ScreenEntity
extends AbstractEntity {
    @DBField(columnName="NAME", insertNulls=true)
    private String name;
    @DBField(columnName="TITLE", insertNulls=true)
    private String title;
    @DBField(columnName="PRIMARY_VIEW_NAME", insertNulls=true)
    private String primaryViewName;
    @DBField(columnName="PRIMARY_VIEWS")
    private JsonNode primaryViews;
    private ScreenNavigation navigation;

    @Override
    public String getIdSequence() {
        String sequence = super.getIdSequence();
        if (StringUtils.isBlank((CharSequence)sequence)) {
            sequence = "APP_SEQ";
        }
        return sequence;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPrimaryViewName() {
        return this.primaryViewName;
    }

    public JsonNode getPrimaryViews() {
        return this.primaryViews;
    }

    public ScreenNavigation getNavigation() {
        return this.navigation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPrimaryViewName(String primaryViewName) {
        this.primaryViewName = primaryViewName;
    }

    public void setPrimaryViews(JsonNode primaryViews) {
        this.primaryViews = primaryViews;
    }

    public void setNavigation(ScreenNavigation navigation) {
        this.navigation = navigation;
    }

    public static class ScreenNavigation {
        private List<Menu> menu;

        public List<Menu> getMenu() {
            return this.menu;
        }

        public void setMenu(List<Menu> menu) {
            this.menu = menu;
        }

        public static class SubMenu
        extends Menu {
            private String viewName;

            public String getViewName() {
                return this.viewName;
            }

            public void setViewName(String viewName) {
                this.viewName = viewName;
            }
        }

        @JsonPropertyOrder(value={"id", "CommentDevelop"})
        public static class Menu {
            private Long id;
            @JsonProperty(value="CommentDevelop")
            private String commentDevelop;
            private String title;
            private String categoryName;
            private List<SubMenu> child;

            public Long getId() {
                return this.id;
            }

            public String getCommentDevelop() {
                return this.commentDevelop;
            }

            public String getTitle() {
                return this.title;
            }

            public String getCategoryName() {
                return this.categoryName;
            }

            public List<SubMenu> getChild() {
                return this.child;
            }

            public void setId(Long id) {
                this.id = id;
            }

            public void setCommentDevelop(String commentDevelop) {
                this.commentDevelop = commentDevelop;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public void setCategoryName(String categoryName) {
                this.categoryName = categoryName;
            }

            public void setChild(List<SubMenu> child) {
                this.child = child;
            }
        }
    }
}

