/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.model.dictionary.listener;

import io.tesler.api.data.dao.databaselistener.IChangeListener;
import io.tesler.api.data.dao.databaselistener.IChangeVector;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.dictionary.entity.AudDictionary;
import io.tesler.model.dictionary.entity.DictionaryItem;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryItemChangeListener
implements IChangeListener<DictionaryItem> {
    @Autowired
    private JpaDao jpaDao;

    public Class<? extends DictionaryItem> getType() {
        return DictionaryItem.class;
    }

    public void process(IChangeVector vector, LOV lov) {
        AudDictionary audDictionary = new AudDictionary();
        if (vector.getEventName() != null) {
            audDictionary.setEventType(vector.getEventName().getKey());
        }
        audDictionary.setEventDate(LocalDateTime.now());
        DictionaryItem item = (DictionaryItem)vector.unwrap(this.getType());
        audDictionary.setDictType(item.getType());
        audDictionary.setKey(item.getKey());
        this.jpaDao.save((Object)audDictionary);
    }
}

