/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.api.data.dictionary.DictionaryCache;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.util.i18n.LocalizationFormatter;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.dictionary.entity.DictionaryItem;
import io.tesler.model.dictionary.entity.DictionaryItem_;
import io.tesler.model.dictionary.entity.DictionaryTypeDesc;
import io.tesler.model.dictionary.entity.DictionaryTypeDesc_;
import io.tesler.source.DictionaryServiceAssociation;
import io.tesler.source.dto.DictionaryItemDTO;
import io.tesler.source.dto.DictionaryItemDTO_;
import io.tesler.source.services.data.DictionaryItemService;
import io.tesler.source.services.meta.DictionaryItemsFieldMetaBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DictionaryItemsServiceImpl
extends VersionAwareResponseService<DictionaryItemDTO, DictionaryItem>
implements DictionaryItemService {
    @Autowired
    private DictionaryCache dictionaryCache;

    public DictionaryItemsServiceImpl() {
        super(DictionaryItemDTO.class, DictionaryItem.class, null, DictionaryItemsFieldMetaBuilder.class);
    }

    protected Specification<DictionaryItem> getParentSpecification(BusinessComponent bc) {
        if (DictionaryServiceAssociation.adminDictionaryItem.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(DictionaryItem_.dictionaryTypeId).get(DictionaryTypeDesc_.id), (Object)bc.getParentIdAsLong())});
        }
        return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]);
    }

    protected ActionResultDTO<DictionaryItemDTO> doUpdateEntity(DictionaryItem item, DictionaryItemDTO data, BusinessComponent bc) {
        DictionaryTypeDesc dictionaryTypeDesc = (DictionaryTypeDesc)this.baseDAO.findById(DictionaryTypeDesc.class, item.getDictionaryTypeId().getId());
        item.setType(dictionaryTypeDesc.getType());
        if (data.isFieldChanged(DictionaryItemDTO_.key)) {
            item.setKey(data.getKey());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.active)) {
            item.setActive(data.getActive().booleanValue());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.displayOrder)) {
            item.setDisplayOrder(data.getDisplayOrder());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.description)) {
            item.setDescription(data.getDescription());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.additionFlg)) {
            item.setAdditionFlg(data.isAdditionFlg());
        }
        DictionaryItemDTO updatedDto = (DictionaryItemDTO)this.entityToDto(bc, (BaseEntity)item);
        return new ActionResultDTO((DataResponseDTO)updatedDto);
    }

    protected CreateResult<DictionaryItemDTO> doCreateEntity(DictionaryItem entity, BusinessComponent bc) {
        DictionaryTypeDesc dictionaryTypeDesc = (DictionaryTypeDesc)this.baseDAO.findById(DictionaryTypeDesc.class, bc.getParentIdAsLong());
        entity.setDictionaryTypeId(dictionaryTypeDesc);
        entity.setType(dictionaryTypeDesc.getType());
        return new CreateResult(this.entityToDto(bc, this.baseDAO.findById(DictionaryItem.class, (Long)this.baseDAO.save((Object)entity))));
    }

    public Actions<DictionaryItemDTO> getActions() {
        return Actions.builder().create().add().save().add().delete().add().action("reload-cache", LocalizationFormatter.uiMessage((String)"action.clearCache")).invoker(this::actionReloadCache).add().build();
    }

    private ActionResultDTO<DictionaryItemDTO> actionReloadCache(BusinessComponent bc, DictionaryItemDTO data) {
        this.dictionaryCache.reload();
        return new ActionResultDTO();
    }

    @Override
    public List<DictionaryItemDTO> reloadCache() {
        this.dictionaryCache.reload();
        List entities = this.baseDAO.getList(DictionaryItem.class);
        return entities.stream().map(DictionaryItemDTO::new).collect(Collectors.toList());
    }
}

