/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tesla.aether.concurrency;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tesla.aether.concurrency.FileLockManager;
import org.eclipse.tesla.aether.concurrency.LockingSyncContext;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.SyncContext;
import org.sonatype.aether.impl.SyncContextFactory;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

@Component(role=SyncContextFactory.class)
public class LockingSyncContextFactory
implements SyncContextFactory,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileLockManager fileLockManager;

    public LockingSyncContextFactory setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public LockingSyncContextFactory setFileLockManager(FileLockManager fileLockManager) {
        this.fileLockManager = fileLockManager;
        return this;
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setFileLockManager((FileLockManager)locator.getService(FileLockManager.class));
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new LockingSyncContext(shared, session, this.fileLockManager, this.logger);
    }
}

