/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tesla.aether.concurrency;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tesla.aether.concurrency.FileLockManager;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

@Component(role=FileProcessor.class, hint="default")
public class LockingFileProcessor
implements FileProcessor,
Service {
    private static Boolean IS_SET_LAST_MODIFIED_SAFE;
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileLockManager fileLockManager;

    public LockingFileProcessor() {
    }

    public LockingFileProcessor(FileLockManager fileLockManager) {
        this.setFileLockManager(fileLockManager);
    }

    public LockingFileProcessor setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public void setFileLockManager(FileLockManager lockManager) {
        if (lockManager == null) {
            throw new IllegalArgumentException("LockManager may not be null.");
        }
        this.fileLockManager = lockManager;
    }

    public void initService(ServiceLocator locator) {
        this.setFileLockManager((FileLockManager)locator.getService(FileLockManager.class));
        this.setLogger((Logger)locator.getService(Logger.class));
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close file: " + e);
            }
        }
    }

    private void unlock(FileLockManager.Lock lock) {
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to unlock file " + lock.getFile() + ": " + e);
            }
        }
    }

    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        FileLockManager.Lock sourceLock = this.fileLockManager.readLock(source);
        FileLockManager.Lock targetLock = this.fileLockManager.writeLock(target);
        try {
            this.mkdirs(target.getParentFile());
            sourceLock.lock();
            targetLock.lock();
            long l = this.copy(sourceLock.getRandomAccessFile(), targetLock.getRandomAccessFile(), listener);
            return l;
        }
        finally {
            this.unlock(sourceLock);
            this.unlock(targetLock);
        }
    }

    private long copy(RandomAccessFile rafIn, RandomAccessFile rafOut, FileProcessor.ProgressListener listener) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        long total = 0L;
        while (true) {
            int bytes;
            if ((bytes = rafIn.read(array)) < 0) break;
            rafOut.write(array, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                buffer.rewind();
                buffer.limit(bytes);
                listener.progressed(buffer);
            }
            catch (Exception e) {
                this.logger.debug("Failed to invoke copy progress listener", (Throwable)e);
            }
        }
        rafOut.setLength(rafOut.getFilePointer());
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String data) throws IOException {
        FileLockManager.Lock lock = this.fileLockManager.writeLock(file);
        try {
            this.mkdirs(file.getParentFile());
            lock.lock();
            RandomAccessFile raf = lock.getRandomAccessFile();
            raf.seek(0L);
            if (data != null) {
                raf.write(data.getBytes("UTF-8"));
            }
            raf.setLength(raf.getFilePointer());
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(File source, File target) throws IOException {
        FileLockManager.Lock sourceLock = this.fileLockManager.writeLock(source);
        FileLockManager.Lock targetLock = this.fileLockManager.writeLock(target);
        try {
            this.mkdirs(target.getParentFile());
            sourceLock.lock();
            targetLock.lock();
            if (!source.renameTo(target)) {
                this.copy(sourceLock.getRandomAccessFile(), targetLock.getRandomAccessFile(), null);
                if (IS_SET_LAST_MODIFIED_SAFE == null) {
                    IS_SET_LAST_MODIFIED_SAFE = target.setLastModified(source.lastModified());
                    this.logger.debug("Updates of file modification timestamp are safe: " + IS_SET_LAST_MODIFIED_SAFE);
                }
                this.close(targetLock.getRandomAccessFile());
                if (IS_SET_LAST_MODIFIED_SAFE.booleanValue()) {
                    target.setLastModified(source.lastModified());
                }
                this.close(sourceLock.getRandomAccessFile());
                source.delete();
            }
        }
        finally {
            this.unlock(sourceLock);
            this.unlock(targetLock);
        }
    }
}

