/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tesla.aether.concurrency;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.tesla.aether.concurrency.FileUtils;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

class LockFile {
    private final Logger logger;
    private final File dataFile;
    private final File lockFile;
    private FileLock fileLock;
    private RandomAccessFile raFile;
    private int refCount;
    private Thread owner;
    private final Map<Thread, AtomicInteger> clients = new HashMap<Thread, AtomicInteger>();

    public LockFile(File dataFile, Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        this.dataFile = dataFile;
        this.lockFile = dataFile.isDirectory() ? new File(dataFile, ".aetherlock") : new File(dataFile.getPath() + ".aetherlock");
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public boolean lock(boolean write) throws IOException {
        if (this.isInvalid()) {
            throw new IllegalStateException("lock for " + this.dataFile + " has been invalidated");
        }
        if (this.isClosed()) {
            this.open(write);
            return true;
        }
        if (this.isReentrant(write)) {
            this.incRefCount();
            return true;
        }
        if (this.isAlreadyHoldByCurrentThread()) {
            throw new IllegalStateException("Cannot acquire " + (write ? "write" : "read") + " lock on " + this.dataFile + " for thread " + Thread.currentThread() + " which already holds incompatible lock");
        }
        return false;
    }

    public void unlock() throws IOException {
        if (this.decRefCount() <= 0) {
            this.close();
        }
    }

    FileLock getFileLock() {
        return this.fileLock;
    }

    public boolean isInvalid() {
        return this.refCount < 0;
    }

    public boolean isShared() {
        if (this.fileLock == null) {
            throw new IllegalStateException("lock not acquired");
        }
        return this.fileLock.isShared();
    }

    private boolean isClosed() {
        return this.fileLock == null;
    }

    private boolean isReentrant(boolean write) {
        if (this.isShared()) {
            return !write;
        }
        return Thread.currentThread() == this.owner;
    }

    private boolean isAlreadyHoldByCurrentThread() {
        return this.clients.get(Thread.currentThread()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void open(boolean write) throws IOException {
        block13: {
            this.refCount = 1;
            this.owner = write != false ? Thread.currentThread() : null;
            this.clients.put(Thread.currentThread(), new AtomicInteger(1));
            raf = null;
            lock = null;
            interrupted = false;
            block8: while (true) {
                while (true) lbl-1000:
                // 3 sources

                {
                    raf = FileUtils.open(this.lockFile, "rw");
                    try {
                        lock = raf.getChannel().lock(0L, 1L, write == false);
                        if (lock == null) {
                            throw new FileLockInterruptionException();
                        }
                        break block13;
                    }
                    catch (FileLockInterruptionException e) {
                        interrupted |= Thread.interrupted();
                        FileUtils.close(raf, null);
                    }
                    catch (IOException e) {
                        FileUtils.close(raf, null);
                        if (this.isPseudoDeadlock(e)) {
                            this.logger.debug("OS detected pseudo deadlock for " + this.lockFile + ", retrying locking");
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e1) {
                                interrupted = true;
                                continue;
                            }
                            continue block8;
                        }
                        this.delete();
                        throw e;
                    }
                    break;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.raFile = raf;
        this.fileLock = lock;
    }

    private boolean isPseudoDeadlock(IOException e) {
        String msg = e.getMessage();
        return msg != null && msg.toLowerCase(Locale.ENGLISH).contains("deadlock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() throws IOException {
        this.refCount = -1;
        if (this.fileLock != null) {
            try {
                if (this.fileLock.isValid()) {
                    this.fileLock.release();
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to release lock on " + this.lockFile + ": " + e);
            }
            finally {
                this.fileLock = null;
            }
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            finally {
                this.raFile = null;
                this.delete();
            }
        }
    }

    private void delete() {
        if (this.lockFile != null && !this.lockFile.delete() && this.lockFile.exists()) {
            this.lockFile.deleteOnExit();
        }
    }

    private int incRefCount() {
        AtomicInteger clientRefCount = this.clients.get(Thread.currentThread());
        if (clientRefCount == null) {
            this.clients.put(Thread.currentThread(), new AtomicInteger(1));
        } else {
            clientRefCount.incrementAndGet();
        }
        return ++this.refCount;
    }

    private int decRefCount() {
        AtomicInteger clientRefCount = this.clients.get(Thread.currentThread());
        if (clientRefCount != null && clientRefCount.decrementAndGet() <= 0) {
            this.clients.remove(Thread.currentThread());
        }
        return --this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

