/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tesla.aether.concurrency;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tesla.aether.concurrency.FileLockManager;
import org.eclipse.tesla.aether.concurrency.FileUtils;
import org.eclipse.tesla.aether.concurrency.LockFile;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

@Component(role=FileLockManager.class)
public class DefaultFileLockManager
implements FileLockManager,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    private static final ConcurrentMap<File, LockFile> lockFiles = new ConcurrentHashMap<File, LockFile>(64);

    public DefaultFileLockManager() {
    }

    public DefaultFileLockManager(Logger logger) {
        this.setLogger(logger);
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
    }

    public FileLockManager.Lock readLock(File target) {
        return new IndirectFileLock(this.normalize(target), false);
    }

    public FileLockManager.Lock writeLock(File target) {
        return new IndirectFileLock(this.normalize(target), true);
    }

    private File normalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            this.logger.warn("Failed to normalize pathname for lock on " + file + ": " + e);
            return file.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LockFile lock(File file, boolean write) throws IOException {
        boolean interrupted = false;
        try {
            while (true) {
                LockFile existing;
                LockFile lockFile;
                if ((lockFile = (LockFile)lockFiles.get(file)) == null && (existing = lockFiles.putIfAbsent(file, lockFile = new LockFile(file, this.logger))) != null) {
                    lockFile = existing;
                }
                LockFile lockFile2 = lockFile;
                synchronized (lockFile2) {
                    if (lockFile.isInvalid()) {
                        continue;
                    }
                    if (lockFile.lock(write)) {
                        LockFile lockFile3 = lockFile;
                        return lockFile3;
                    }
                    try {
                        lockFile.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(LockFile lockFile) throws IOException {
        LockFile lockFile2 = lockFile;
        synchronized (lockFile2) {
            try {
                lockFile.unlock();
            }
            finally {
                if (lockFile.isInvalid()) {
                    lockFiles.remove(lockFile.getDataFile(), lockFile);
                    lockFile.notifyAll();
                }
            }
        }
    }

    class IndirectFileLock
    implements FileLockManager.Lock {
        private final File file;
        private final boolean write;
        private final Throwable stackTrace;
        private RandomAccessFile raFile;
        private LockFile lockFile;
        private int nesting;

        public IndirectFileLock(File file, boolean write) {
            this.file = file;
            this.write = write;
            this.stackTrace = new IllegalStateException();
        }

        public synchronized void lock() throws IOException {
            if (this.lockFile == null) {
                this.open();
                this.nesting = 1;
            } else {
                ++this.nesting;
            }
        }

        private void open() throws IOException {
            this.lockFile = DefaultFileLockManager.this.lock(this.file, this.write);
        }

        public synchronized void unlock() throws IOException {
            --this.nesting;
            if (this.nesting <= 0) {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() throws IOException {
            block16: {
                try {
                    if (this.raFile == null) break block16;
                    try {
                        this.raFile.close();
                    }
                    finally {
                        this.raFile = null;
                    }
                }
                finally {
                    if (this.lockFile != null) {
                        try {
                            DefaultFileLockManager.this.unlock(this.lockFile);
                        }
                        catch (IOException e) {
                            DefaultFileLockManager.this.logger.warn("Failed to release lock for " + this.file + ": " + e);
                        }
                        finally {
                            this.lockFile = null;
                        }
                    }
                }
            }
        }

        public RandomAccessFile getRandomAccessFile() throws IOException {
            if (this.raFile == null && this.lockFile != null && this.lockFile.getFileLock().isValid()) {
                this.raFile = FileUtils.open(this.file, this.write ? "rw" : "r");
            }
            return this.raFile;
        }

        public boolean isShared() {
            if (this.lockFile == null) {
                throw new IllegalStateException("lock not acquired");
            }
            return this.lockFile.isShared();
        }

        public FileLock getLock() {
            if (this.lockFile == null) {
                return null;
            }
            return this.lockFile.getFileLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.lockFile != null) {
                    DefaultFileLockManager.this.logger.warn("Lock on file " + this.file + " has not been properly released", this.stackTrace);
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        public File getFile() {
            return this.file;
        }
    }
}

