/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tesla.aether.concurrency;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.tesla.aether.concurrency.FileLockManager;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.SyncContext;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LockingSyncContext
implements SyncContext {
    private static final char SEPARATOR = '~';
    private final Logger logger;
    private final FileLockManager fileLockManager;
    private final LocalRepositoryManager localRepoMan;
    private final boolean shared;
    private final Map<String, FileLockManager.Lock> locks = new LinkedHashMap<String, FileLockManager.Lock>();

    public LockingSyncContext(boolean shared, RepositorySystemSession session, FileLockManager fileLockManager, Logger logger) {
        this.shared = shared;
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        this.fileLockManager = fileLockManager;
        this.localRepoMan = session.getLocalRepositoryManager();
    }

    public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        TreeSet<String> paths = new TreeSet<String>();
        this.addArtifactPaths(paths, artifacts);
        this.addMetadataPaths(paths, metadatas);
        File basedir = this.getLockBasedir();
        for (String path : paths) {
            File file = new File(basedir, path);
            FileLockManager.Lock lock = this.locks.get(path);
            if (lock != null) continue;
            lock = this.shared ? this.fileLockManager.readLock(file) : this.fileLockManager.writeLock(file);
            this.locks.put(path, lock);
            try {
                lock.lock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to lock file " + lock.getFile() + ": " + e);
            }
        }
    }

    private File getLockBasedir() {
        LocalRepository localRepo = this.localRepoMan.getRepository();
        File basedir = new File(localRepo.getBasedir(), ".locks");
        return basedir;
    }

    private void addArtifactPaths(Collection<String> paths, Collection<? extends Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                String path = this.getPath(artifact);
                paths.add(path);
            }
        }
    }

    private String getPath(Artifact artifact) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId()).append('~');
        path.append(artifact.getArtifactId()).append('~');
        path.append(artifact.getBaseVersion());
        return path.toString();
    }

    private void addMetadataPaths(Collection<String> paths, Collection<? extends Metadata> metadatas) {
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                String path = this.getPath(metadata);
                paths.add(path);
            }
        }
    }

    private String getPath(Metadata metadata) {
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId());
            if (metadata.getArtifactId().length() > 0) {
                path.append('~').append(metadata.getArtifactId());
                if (metadata.getVersion().length() > 0) {
                    path.append('~').append(metadata.getVersion());
                }
            }
        }
        return path.toString();
    }

    public void release() {
        for (FileLockManager.Lock lock : this.locks.values()) {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to unlock file " + lock.getFile() + ": " + e);
            }
        }
        this.locks.clear();
    }
}

